/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoDistanceShape;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.XYZBounds;

class Geo3DPointDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final GeoDistanceShape distanceShape;
    final double[] values;
    double bottomDistance;
    double topValue;
    SortedNumericDocValues currentDocs;
    XYZBounds priorityQueueBounds;
    int setBottomCounter = 0;

    public Geo3DPointDistanceComparator(String field, GeoDistanceShape distanceShape, int numHits) {
        this.field = field;
        this.distanceShape = distanceShape;
        this.values = new double[numHits];
    }

    @Override
    public void setScorer(Scorer scorer) {
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setBottom(int slot) {
        this.bottomDistance = this.values[slot];
        if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
            XYZBounds bounds = new XYZBounds();
            this.distanceShape.getDistanceBounds(bounds, DistanceStyle.ARC, this.bottomDistance);
            this.priorityQueueBounds = bounds;
        }
        ++this.setBottomCounter;
    }

    @Override
    public void setTopValue(Double value) {
        this.topValue = value;
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        this.currentDocs.setDocument(doc);
        int numValues = this.currentDocs.count();
        if (numValues == 0) {
            return Double.compare(this.bottomDistance, Double.POSITIVE_INFINITY);
        }
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double x = Geo3DDocValuesField.decodeXValue(encoded);
            double y = Geo3DDocValuesField.decodeYValue(encoded);
            double z = Geo3DDocValuesField.decodeZValue(encoded);
            if (x > this.priorityQueueBounds.getMaximumX() || x < this.priorityQueueBounds.getMinimumX() || y > this.priorityQueueBounds.getMaximumY() || y < this.priorityQueueBounds.getMinimumY() || z > this.priorityQueueBounds.getMaximumZ() || z < this.priorityQueueBounds.getMinimumZ()) continue;
            cmp = Math.max(cmp, Double.compare(this.bottomDistance, this.distanceShape.computeDistance(DistanceStyle.ARC, x, y, z)));
        }
        return cmp;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.computeMinimumDistance(doc);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            Geo3DDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric(reader, this.field);
        return this;
    }

    @Override
    public Double value(int slot) {
        return this.values[slot] * 6371008.7714;
    }

    @Override
    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, this.computeMinimumDistance(doc));
    }

    double computeMinimumDistance(int doc) {
        this.currentDocs.setDocument(doc);
        double minValue = Double.POSITIVE_INFINITY;
        int numValues = this.currentDocs.count();
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double distance = this.distanceShape.computeDistance(DistanceStyle.ARC, Geo3DDocValuesField.decodeXValue(encoded), Geo3DDocValuesField.decodeYValue(encoded), Geo3DDocValuesField.decodeZValue(encoded));
            minValue = Math.min(minValue, distance);
        }
        return minValue;
    }
}

