/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class Multiset<T>
extends AbstractCollection<T> {
    private final Map<T, Integer> map = new HashMap<T, Integer>();
    private int size;

    Multiset() {
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, Integer>> mapIterator = this.map.entrySet().iterator();
        return new Iterator<T>(){
            T current;
            int remaining;

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || mapIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.remaining == 0) {
                    Map.Entry next = (Map.Entry)mapIterator.next();
                    this.current = next.getKey();
                    this.remaining = (Integer)next.getValue();
                }
                assert (this.remaining > 0);
                --this.remaining;
                return this.current;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    @Override
    public boolean add(T e) {
        this.map.put(e, this.map.getOrDefault(e, 0) + 1);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Integer count = this.map.get(o);
        if (count == null) {
            return false;
        }
        if (1 == count) {
            this.map.remove(o);
        } else {
            this.map.put(o, count - 1);
        }
        --this.size;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Multiset that = (Multiset)obj;
        return this.size == that.size && this.map.equals(that.map);
    }

    @Override
    public int hashCode() {
        return 31 * this.getClass().hashCode() + this.map.hashCode();
    }
}

