/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new FunctionWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return this.func.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.func.equals(((FunctionQuery)other).func);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float qWeight;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float qWeight) throws IOException {
            super(w);
            this.weight = w;
            this.qWeight = qWeight;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all(context.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        @Override
        public float score() throws IOException {
            float score = this.qWeight * this.vals.floatVal(this.docID());
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            return Explanation.match(sc, "FunctionQuery(" + FunctionQuery.this.func + "), product of:", this.vals.explain(doc), Explanation.match(this.weight.boost, "boost", new Explanation[0]), Explanation.match(this.weight.queryNorm, "queryNorm", new Explanation[0]));
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected float queryNorm;
        protected float boost;
        protected float queryWeight;
        protected final Map context;

        public FunctionWeight(IndexSearcher searcher) throws IOException {
            super(FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
            this.normalize(1.0f, 1.0f);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float boost) {
            this.queryNorm = norm;
            this.boost = boost;
            this.queryWeight = norm * boost;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new AllScorer(context, this, this.queryWeight);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc);
        }
    }
}

