/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoublePredicate;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

public final class FunctionMatchQuery
extends Query {
    private final DoubleValuesSource source;
    private final DoublePredicate filter;

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter) {
        this.source = source;
        this.filter = filter;
    }

    @Override
    public String toString(String field) {
        return "FunctionMatchQuery(" + this.source.toString() + ")";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final DoubleValues values = FunctionMatchQuery.this.source.getValues(context, null);
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        return values.advanceExact(this.approximation.docID()) && FunctionMatchQuery.this.filter.test(values.doubleValue());
                    }

                    @Override
                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionMatchQuery that = (FunctionMatchQuery)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.filter);
    }
}

