/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.FieldsConsumer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.FieldsProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.perfield.PerFieldMergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FilterLeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountables;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.RamUsageEstimator;

public abstract class PerFieldPostingsFormat
extends PostingsFormat {
    public static final String PER_FIELD_NAME = "PerField40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".suffix";

    public PerFieldPostingsFormat() {
        super(PER_FIELD_NAME);
    }

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    static String getFullSegmentSuffix(String fieldName, String outerSegmentSuffix, String segmentSuffix) {
        if (outerSegmentSuffix.length() == 0) {
            return segmentSuffix;
        }
        throw new IllegalStateException("cannot embed PerFieldPostingsFormat inside itself (field \"" + fieldName + "\" returned PerFieldPostingsFormat)");
    }

    @Override
    public final FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new FieldsWriter(state);
    }

    @Override
    public final FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    public abstract PostingsFormat getPostingsFormatForField(String var1);

    private static class FieldsReader
    extends FieldsProducer {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldsReader.class);
        private final Map<String, FieldsProducer> fields = new TreeMap<String, FieldsProducer>();
        private final Map<String, FieldsProducer> formats = new HashMap<String, FieldsProducer>();
        private final String segment;

        FieldsReader(FieldsReader other) throws IOException {
            IdentityHashMap<FieldsProducer, FieldsProducer> oldToNew = new IdentityHashMap<FieldsProducer, FieldsProducer>();
            for (Map.Entry<String, FieldsProducer> ent : other.formats.entrySet()) {
                FieldsProducer values = ent.getValue().getMergeInstance();
                this.formats.put(ent.getKey(), values);
                oldToNew.put(ent.getValue(), values);
            }
            for (Map.Entry<String, FieldsProducer> ent : other.fields.entrySet()) {
                FieldsProducer producer = (FieldsProducer)oldToNew.get(ent.getValue());
                assert (producer != null);
                this.fields.put(ent.getKey(), producer);
            }
            this.segment = other.segment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FieldsReader(SegmentReadState readState) throws IOException {
            boolean success = false;
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (fi.getIndexOptions() == IndexOptions.NONE) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    if (suffix == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + fieldName);
                    }
                    PostingsFormat format = PostingsFormat.forName(formatName);
                    String segmentSuffix = PerFieldPostingsFormat.getSuffix(formatName, suffix);
                    if (!this.formats.containsKey(segmentSuffix)) {
                        this.formats.put(segmentSuffix, format.fieldsProducer(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fieldName, this.formats.get(segmentSuffix));
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.formats.values());
                }
            }
            this.segment = readState.segmentInfo.name;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldsProducer fieldsProducer = this.fields.get(field);
            return fieldsProducer == null ? null : fieldsProducer.terms(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        @Override
        public long ramBytesUsed() {
            long ramBytesUsed = BASE_RAM_BYTES_USED;
            ramBytesUsed += (long)this.fields.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            ramBytesUsed += (long)this.formats.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            for (Map.Entry<String, FieldsProducer> entry : this.formats.entrySet()) {
                ramBytesUsed += entry.getValue().ramBytesUsed();
            }
            return ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Accountables.namedAccountables("format", this.formats);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.formats.values()) {
                producer.checkIntegrity();
            }
        }

        @Override
        public FieldsProducer getMergeInstance() throws IOException {
            return new FieldsReader(this);
        }

        public String toString() {
            return "PerFieldPostings(segment=" + this.segment + " formats=" + this.formats.size() + ")";
        }
    }

    private class FieldsWriter
    extends FieldsConsumer {
        final SegmentWriteState writeState;
        final List<Closeable> toClose = new ArrayList<Closeable>();

        public FieldsWriter(SegmentWriteState writeState) {
            this.writeState = writeState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Fields fields) throws IOException {
            Map<PostingsFormat, FieldsGroup> formatToGroups = this.buildFieldsGroupMapping(fields);
            boolean success = false;
            try {
                for (Map.Entry<PostingsFormat, FieldsGroup> ent : formatToGroups.entrySet()) {
                    PostingsFormat format = ent.getKey();
                    final FieldsGroup group = ent.getValue();
                    FilterLeafReader.FilterFields maskedFields = new FilterLeafReader.FilterFields(fields){

                        @Override
                        public Iterator<String> iterator() {
                            return group.fields.iterator();
                        }
                    };
                    FieldsConsumer consumer = format.fieldsConsumer(group.state);
                    this.toClose.add(consumer);
                    consumer.write(maskedFields);
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toClose);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void merge(MergeState mergeState) throws IOException {
            Map<PostingsFormat, FieldsGroup> formatToGroups = this.buildFieldsGroupMapping(new MultiFields(mergeState.fieldsProducers, null));
            PerFieldMergeState pfMergeState = new PerFieldMergeState(mergeState);
            boolean success = false;
            try {
                for (Map.Entry<PostingsFormat, FieldsGroup> ent : formatToGroups.entrySet()) {
                    PostingsFormat format = ent.getKey();
                    FieldsGroup group = ent.getValue();
                    FieldsConsumer consumer = format.fieldsConsumer(group.state);
                    this.toClose.add(consumer);
                    consumer.merge(pfMergeState.apply(group.fields));
                }
                success = true;
            }
            finally {
                pfMergeState.reset();
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toClose);
                }
            }
        }

        private Map<PostingsFormat, FieldsGroup> buildFieldsGroupMapping(Fields fields) {
            HashMap<PostingsFormat, FieldsGroup> formatToGroups = new HashMap<PostingsFormat, FieldsGroup>();
            HashMap<String, Integer> suffixes = new HashMap<String, Integer>();
            for (String field : fields) {
                FieldInfo fieldInfo = this.writeState.fieldInfos.fieldInfo(field);
                PostingsFormat format = PerFieldPostingsFormat.this.getPostingsFormatForField(field);
                if (format == null) {
                    throw new IllegalStateException("invalid null PostingsFormat for field=\"" + field + "\"");
                }
                String formatName = format.getName();
                FieldsGroup group = (FieldsGroup)formatToGroups.get(format);
                if (group == null) {
                    Integer suffix = (Integer)suffixes.get(formatName);
                    suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                    suffixes.put(formatName, suffix);
                    String segmentSuffix = PerFieldPostingsFormat.getFullSegmentSuffix(field, this.writeState.segmentSuffix, PerFieldPostingsFormat.getSuffix(formatName, Integer.toString(suffix)));
                    group = new FieldsGroup();
                    group.state = new SegmentWriteState(this.writeState, segmentSuffix);
                    group.suffix = suffix;
                    formatToGroups.put(format, group);
                } else if (!suffixes.containsKey(formatName)) {
                    throw new IllegalStateException("no suffix for format name: " + formatName + ", expected: " + group.suffix);
                }
                group.fields.add(field);
                String previousValue = fieldInfo.putAttribute(PER_FIELD_FORMAT_KEY, formatName);
                if (previousValue != null) {
                    throw new IllegalStateException("found existing value for " + PER_FIELD_FORMAT_KEY + ", field=" + fieldInfo.name + ", old=" + previousValue + ", new=" + formatName);
                }
                previousValue = fieldInfo.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(group.suffix));
                if (previousValue == null) continue;
                throw new IllegalStateException("found existing value for " + PER_FIELD_SUFFIX_KEY + ", field=" + fieldInfo.name + ", old=" + previousValue + ", new=" + group.suffix);
            }
            return formatToGroups;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.toClose);
        }
    }

    static class FieldsGroup {
        final Set<String> fields = new TreeSet<String>();
        int suffix;
        SegmentWriteState state;

        FieldsGroup() {
        }
    }
}

