/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.lucene60;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PointsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountables;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.bkd.BKDReader;

public class Lucene60PointsReader
extends PointsReader
implements Closeable {
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, BKDReader> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene60PointsReader(SegmentReadState readState) throws IOException {
        HashMap<Integer, Long> fieldToFileOffset;
        block21: {
            this.readers = new HashMap<Integer, BKDReader>();
            this.readState = readState;
            String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dii");
            fieldToFileOffset = new HashMap<Integer, Long>();
            try (ChecksumIndexInput indexIn = readState.directory.openChecksumInput(indexFileName, readState.context);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(indexIn, "Lucene60PointsFormatMeta", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                    int count = indexIn.readVInt();
                    for (int i = 0; i < count; ++i) {
                        int fieldNumber = indexIn.readVInt();
                        long fp = indexIn.readVLong();
                        fieldToFileOffset.put(fieldNumber, fp);
                    }
                }
                catch (Throwable t) {
                    try {
                        priorE = t;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(indexIn, priorE);
                    }
                }
                CodecUtil.checkFooter(indexIn, priorE);
            }
        }
        String dataFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dim");
        boolean success = false;
        this.dataIn = readState.directory.openInput(dataFileName, readState.context);
        try {
            CodecUtil.checkIndexHeader(this.dataIn, "Lucene60PointsFormatData", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
            CodecUtil.retrieveChecksum(this.dataIn);
            for (Map.Entry ent : fieldToFileOffset.entrySet()) {
                int fieldNumber = (Integer)ent.getKey();
                long fp = (Long)ent.getValue();
                this.dataIn.seek(fp);
                BKDReader reader = new BKDReader(this.dataIn);
                this.readers.put(fieldNumber, reader);
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    public BKDReader getBKDReader(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    @Override
    public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return;
        }
        bkdReader.intersect(visitor);
    }

    @Override
    public long estimatePointCount(String fieldName, PointValues.IntersectVisitor visitor) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0L;
        }
        return bkdReader.estimatePointCount(visitor);
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        for (BKDReader reader : this.readers.values()) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        for (Map.Entry<Integer, BKDReader> ent : this.readers.entrySet()) {
            resources.add(Accountables.namedAccountable(this.readState.fieldInfos.fieldInfo((int)ent.getKey().intValue()).name, ent.getValue()));
        }
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        this.dataIn.close();
        this.readers.clear();
    }

    @Override
    public byte[] getMinPackedValue(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return null;
        }
        return bkdReader.getMinPackedValue();
    }

    @Override
    public byte[] getMaxPackedValue(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return null;
        }
        return bkdReader.getMaxPackedValue();
    }

    @Override
    public int getNumDimensions(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getNumDimensions();
    }

    @Override
    public int getBytesPerDimension(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getBytesPerDimension();
    }

    @Override
    public long size(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0L;
        }
        return bkdReader.getPointCount();
    }

    @Override
    public int getDocCount(String fieldName) {
        BKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getDocCount();
    }
}

