/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CharFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.AttributeFactory;

public abstract class Tokenizer
extends TokenStream {
    protected Reader input = ILLEGAL_STATE_READER;
    private Reader inputPending = ILLEGAL_STATE_READER;
    private static final Reader ILLEGAL_STATE_READER = new Reader(){

        @Override
        public int read(char[] cbuf, int off, int len) {
            throw new IllegalStateException("TokenStream contract violation: reset()/close() call missing, reset() called multiple times, or subclass does not call super.reset(). Please see Javadocs of TokenStream class for more information about the correct consuming workflow.");
        }

        @Override
        public void close() {
        }
    };

    protected Tokenizer() {
    }

    protected Tokenizer(AttributeFactory factory) {
        super(factory);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.inputPending = this.input = ILLEGAL_STATE_READER;
    }

    protected final int correctOffset(int currentOff) {
        return this.input instanceof CharFilter ? ((CharFilter)this.input).correctOffset(currentOff) : currentOff;
    }

    public final void setReader(Reader input) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (this.input != ILLEGAL_STATE_READER) {
            throw new IllegalStateException("TokenStream contract violation: close() call missing");
        }
        this.inputPending = input;
        this.setReaderTestPoint();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.input = this.inputPending;
        this.inputPending = ILLEGAL_STATE_READER;
    }

    void setReaderTestPoint() {
    }
}

