/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.AbstractFloatCollection;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.AbstractIterator;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.FloatContainer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.FloatIndexedContainer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.Preallocable;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.FloatCursor;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.predicates.FloatPredicate;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.procedures.FloatProcedure;

public class FloatArrayList
extends AbstractFloatCollection
implements FloatIndexedContainer,
Preallocable,
Cloneable {
    public static final float[] EMPTY_ARRAY = new float[0];
    public float[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public FloatArrayList() {
        this(4);
    }

    public FloatArrayList(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayList(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public FloatArrayList(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(float[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(float ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(FloatContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (FloatCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.add(floatCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, float e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public float get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public float set(int index, float e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        float v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public float remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        float v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0.0f;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0.0f);
    }

    @Override
    public int removeFirst(float e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(float e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(float e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (Float.floatToIntBits(this.buffer[from]) == Float.floatToIntBits(e1)) {
                this.buffer[from] = 0.0f;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0.0f;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(float e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(float e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (Float.floatToIntBits(this.buffer[i]) != Float.floatToIntBits(e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (Float.floatToIntBits(this.buffer[i]) != Float.floatToIntBits(e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0.0f);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0.0f);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0f);
        this.elementsCount = 0;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public float[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public FloatArrayList clone() {
        try {
            FloatArrayList cloned = (FloatArrayList)super.clone();
            cloned.buffer = (float[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((FloatArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(FloatArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (Float.floatToIntBits(other.get(i)) == Float.floatToIntBits(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends FloatProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        int from;
        float[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = 0.0f;
                    continue;
                }
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0.0f;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0.0f;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends FloatPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static FloatArrayList from(float ... elements) {
        FloatArrayList list = new FloatArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final float[] buffer;
        private final int size;

        public ValueIterator(float[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected FloatCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (FloatCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

