/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.sort;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;

public class Sort {
    private String field;
    private Sorting order;
    private Object missing;
    private Boolean unmapped;

    public Sort(String field) {
        this.field = field;
    }

    public Sort(String field, Sorting order) {
        this.field = field;
        this.order = order;
    }

    public void setMissing(Object m) {
        this.missing = m;
    }

    public void setIgnoreUnmapped() {
        this.unmapped = true;
    }

    public JsonNode toJsonObject(ObjectMapper objectMapper) {
        ObjectNode sortDefinition = objectMapper.createObjectNode();
        if (this.order != null) {
            sortDefinition.set("order", (JsonNode)new TextNode(this.order.toString()));
        }
        if (this.missing != null) {
            sortDefinition.set("missing", (JsonNode)new TextNode(this.missing.toString()));
        }
        if (this.unmapped != null) {
            sortDefinition.set("ignore_unmapped", (JsonNode)BooleanNode.valueOf((boolean)this.unmapped));
        }
        ObjectNode sortObject = objectMapper.createObjectNode();
        sortObject.set(this.field, (JsonNode)sortDefinition);
        return sortObject;
    }

    public static enum Missing {
        LAST("_last"),
        FIRST("_first");

        private final String name;

        private Missing(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Sorting {
        ASC("asc"),
        DESC("desc");

        private final String name;

        private Sorting(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

