/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Time;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;

public class ESTimeHandler
extends ESPivotBucketSpecHandler<Time, ParsedDateHistogram> {
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Time timeSpec, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext, Query query) {
        DateHistogramInterval dateHistogramInterval = new DateHistogramInterval(timeSpec.interval().toDateInterval(query.effectiveTimeRange((SearchType)pivot)).toString());
        Optional<BucketOrder> ordering = this.orderForPivot(pivot, timeSpec, esGeneratedQueryContext);
        DateHistogramAggregationBuilder builder = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram(name).field(timeSpec.field())).order(ordering.orElse(BucketOrder.key(true))).format("date_time");
        this.setInterval(builder, dateHistogramInterval);
        this.record(esGeneratedQueryContext, pivot, (PivotSpec)timeSpec, name, ParsedDateHistogram.class);
        return Optional.of(builder);
    }

    private void setInterval(DateHistogramAggregationBuilder builder, DateHistogramInterval interval) {
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) != null) {
            builder.calendarInterval(interval);
        } else {
            builder.fixedInterval(interval);
        }
    }

    private Optional<BucketOrder> orderForPivot(Pivot pivot, Time timeSpec, ESGeneratedQueryContext esGeneratedQueryContext) {
        return pivot.sort().stream().map(sortSpec -> {
            if (sortSpec instanceof PivotSort && timeSpec.field().equals(sortSpec.field())) {
                return sortSpec.direction().equals((Object)SortSpec.Direction.Ascending) ? BucketOrder.key(true) : BucketOrder.key(false);
            }
            if (sortSpec instanceof SeriesSort) {
                Optional<SeriesSpec> matchingSeriesSpec = pivot.series().stream().filter(series -> series.literal().equals(sortSpec.field())).findFirst();
                return matchingSeriesSpec.map(seriesSpec -> {
                    if (seriesSpec.literal().equals("count()")) {
                        return sortSpec.direction().equals((Object)SortSpec.Direction.Ascending) ? BucketOrder.count(true) : BucketOrder.count(false);
                    }
                    return BucketOrder.aggregation(esGeneratedQueryContext.seriesName((SeriesSpec)seriesSpec, pivot), sortSpec.direction().equals((Object)SortSpec.Direction.Ascending));
                }).orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }

    @Override
    public Stream<ESPivotBucketSpecHandler.Bucket> doHandleResult(Pivot pivot, Time bucketSpec, SearchResponse searchResult, ParsedDateHistogram dateHistogramAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        return dateHistogramAggregation.getBuckets().stream().map(dateHistogram -> ESPivotBucketSpecHandler.Bucket.create(dateHistogram.getKeyAsString(), dateHistogram));
    }
}

