/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import java.util.Set;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.ScrollResultES7;
import org.graylog.storage.elasticsearch7.SearchRequestFactory;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.ScrollCommand;

public class Scroll {
    private static final String DEFAULT_SCROLLTIME = "1m";
    private final ElasticsearchClient client;
    private final ScrollResultES7.Factory scrollResultFactory;
    private final SearchRequestFactory searchRequestFactory;

    @Inject
    public Scroll(ElasticsearchClient client, ScrollResultES7.Factory scrollResultFactory, SearchRequestFactory searchRequestFactory) {
        this.client = client;
        this.scrollResultFactory = scrollResultFactory;
        this.searchRequestFactory = searchRequestFactory;
    }

    public ScrollResult scroll(ScrollCommand scrollCommand) {
        SearchSourceBuilder searchQuery = this.searchRequestFactory.create(scrollCommand);
        searchQuery.fetchSource(scrollCommand.fields().toArray(new String[0]), new String[0]);
        scrollCommand.batchSize().ifPresent(batchSize -> searchQuery.size(Math.toIntExact(batchSize)));
        SearchRequest request = this.scrollBuilder(searchQuery, scrollCommand.indices());
        SearchResponse result = this.client.singleSearch(request, "Unable to perform scroll search");
        return this.scrollResultFactory.create(result, searchQuery.toString(), DEFAULT_SCROLLTIME, scrollCommand.fields(), scrollCommand.limit().orElse(-1));
    }

    private SearchRequest scrollBuilder(SearchSourceBuilder query, Set<String> indices) {
        return new SearchRequest(indices.toArray(new String[0])).source(query).scroll(DEFAULT_SCROLLTIME);
    }
}

