/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public class MinAndMax<T extends Comparable<? super T>>
implements Writeable {
    private final T minValue;
    private final T maxValue;

    public MinAndMax(T minValue, T maxValue) {
        this.minValue = (Comparable)Objects.requireNonNull(minValue);
        this.maxValue = (Comparable)Objects.requireNonNull(maxValue);
    }

    public MinAndMax(StreamInput in) throws IOException {
        this.minValue = Lucene.readSortValue(in);
        this.maxValue = Lucene.readSortValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Lucene.writeSortValue(out, this.minValue);
        Lucene.writeSortValue(out, this.maxValue);
    }

    public T getMin() {
        return this.minValue;
    }

    public T getMax() {
        return this.maxValue;
    }

    public static Comparator<MinAndMax<?>> getComparator(SortOrder order) {
        Comparator<MinAndMax> cmp;
        Comparator<MinAndMax> comparator = cmp = order == SortOrder.ASC ? Comparator.comparing(MinAndMax::getMin) : Comparator.comparing(MinAndMax::getMax);
        if (order == SortOrder.DESC) {
            cmp = cmp.reversed();
        }
        return Comparator.nullsLast(cmp);
    }
}

