/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup.FieldLookup;

public class LeafFieldsLookup
implements Map {
    private final MapperService mapperService;
    @Nullable
    private final String[] types;
    private final LeafReader reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();

    LeafFieldsLookup(MapperService mapperService, @Nullable String[] types, LeafReader reader) {
        this.mapperService = mapperService;
        this.types = types;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    public Object get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            MappedFieldType fieldType = this.mapperService.fieldType(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping with types " + Arrays.toString(this.types));
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            ArrayList<Object> values;
            if ("_type".equals(data.fieldType().name())) {
                values = new ArrayList<Object>(1);
                DocumentMapper mapper = this.mapperService.documentMapper();
                if (mapper != null) {
                    values.add(mapper.type());
                }
            } else {
                values = new ArrayList(2);
                SingleFieldsVisitor visitor = new SingleFieldsVisitor(data.fieldType(), values);
                try {
                    this.reader.document(this.docId, visitor);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to load field [{}]", (Throwable)e, name);
                }
            }
            data.fields(Collections.singletonMap(data.fieldType().name(), values));
        }
        return data;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

