/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.OriginalIndices;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.ShardFetchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContextId;

public class ShardFetchSearchRequest
extends ShardFetchRequest
implements IndicesRequest {
    private OriginalIndices originalIndices;

    public ShardFetchSearchRequest() {
    }

    public ShardFetchSearchRequest(OriginalIndices originalIndices, SearchContextId id, IntArrayList list, ScoreDoc lastEmittedDoc) {
        super(id, list, lastEmittedDoc);
        this.originalIndices = originalIndices;
    }

    public ShardFetchSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }
}

