/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchShardTarget;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContextId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.query.QuerySearchResult;

public final class FetchSearchResult
extends SearchPhaseResult {
    private SearchHits hits;
    private transient int counter;

    public FetchSearchResult() {
    }

    public FetchSearchResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new SearchContextId(in);
        this.hits = new SearchHits(in);
    }

    public FetchSearchResult(SearchContextId id, SearchShardTarget shardTarget) {
        this.contextId = id;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public QuerySearchResult queryResult() {
        return null;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this;
    }

    public void hits(SearchHits hits) {
        assert (this.assertNoSearchTarget(hits));
        this.hits = hits;
    }

    private boolean assertNoSearchTarget(SearchHits hits) {
        for (SearchHit hit : hits.getHits()) {
            assert (hit.getShard() == null) : "expected null but got: " + hit.getShard();
        }
        return true;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public FetchSearchResult initCounter() {
        this.counter = 0;
        return this;
    }

    public int counterGetAndIncrement() {
        return this.counter++;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.contextId.writeTo(out);
        this.hits.writeTo(out);
    }
}

