/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.values;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.ScorerAware;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.AggregationScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.joda.time.ReadableInstant;

public class ScriptDoubleValues
extends SortingNumericDoubleValues
implements ScorerAware {
    final AggregationScript script;

    public ScriptDoubleValues(AggregationScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        this.script.setDocument(target);
        Object value = this.script.execute();
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            this.resize(1);
            this.values[0] = ((Number)value).doubleValue();
        } else if (value instanceof ReadableInstant) {
            this.resize(1);
            this.values[0] = ((ReadableInstant)value).getMillis();
        } else if (value instanceof ZonedDateTime) {
            this.resize(1);
            this.values[0] = ((ZonedDateTime)value).toInstant().toEpochMilli();
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            this.resize(length);
            for (int i = 0; i < length; ++i) {
                this.values[i] = ScriptDoubleValues.toDoubleValue(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            this.resize(coll.size());
            int i = 0;
            for (Object v : coll) {
                this.values[i++] = ScriptDoubleValues.toDoubleValue(v);
            }
            assert (i == this.docValueCount());
        } else {
            this.resize(1);
            this.values[0] = ScriptDoubleValues.toDoubleValue(value);
        }
        this.sort();
        return true;
    }

    private static double toDoubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof ReadableInstant) {
            return ((ReadableInstant)o).getMillis();
        }
        if (o instanceof ZonedDateTime) {
            return ((ZonedDateTime)o).toInstant().toEpochMilli();
        }
        if (o instanceof JodaCompatibleZonedDateTime) {
            return ((JodaCompatibleZonedDateTime)o).toInstant().toEpochMilli();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        throw new AggregationExecutionException("Unsupported script value [" + o + "], expected a number, date, or boolean");
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.script.setScorer(scorer);
    }
}

