/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;

public class AvgBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private int count = 0;
    private double sum = 0.0;

    AvgBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, format, metadata);
    }

    public AvgBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "avg_bucket";
    }

    @Override
    protected void preCollection() {
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        ++this.count;
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        double avgValue = this.count == 0 ? Double.NaN : this.sum / (double)this.count;
        return new InternalSimpleValue(this.name(), avgValue, this.format, metadata);
    }
}

