/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.ingest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;

public class RestDeletePipelineAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_delete_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        DeletePipelineRequest request = new DeletePipelineRequest(restRequest.param("id"));
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().deletePipeline(request, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

