/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest;

import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.metrics.CounterMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.metrics.MeanMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestStats;

class IngestMetric {
    private final MeanMetric ingestTime = new MeanMetric();
    private final AtomicLong ingestCurrent = new AtomicLong();
    private final CounterMetric ingestCount = new CounterMetric();
    private final CounterMetric ingestFailed = new CounterMetric();

    IngestMetric() {
    }

    void preIngest() {
        this.ingestCurrent.incrementAndGet();
    }

    void postIngest(long ingestTimeInMillis) {
        this.ingestCurrent.decrementAndGet();
        this.ingestTime.inc(ingestTimeInMillis);
        this.ingestCount.inc();
    }

    void ingestFailed() {
        this.ingestFailed.inc();
    }

    void add(IngestMetric metrics) {
        this.ingestCount.inc(metrics.ingestCount.count());
        this.ingestTime.inc(metrics.ingestTime.sum());
        this.ingestFailed.inc(metrics.ingestFailed.count());
    }

    IngestStats.Stats createStats() {
        return new IngestStats.Stats(this.ingestCount.count(), this.ingestTime.sum(), this.ingestCurrent.get(), this.ingestFailed.count());
    }
}

