/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Iterators;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DynamicKeyFieldTypeLookup;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldAliasMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    private final Map<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
    private final Map<String, String> aliasToConcreteName = new HashMap<String, String>();
    private final DynamicKeyFieldTypeLookup dynamicKeyLookup;

    FieldTypeLookup() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        HashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = new HashMap<String, DynamicKeyFieldMapper>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            this.fullNameToFieldType.put(fieldType.name(), fieldType);
            if (!(fieldMapper instanceof DynamicKeyFieldMapper)) continue;
            dynamicKeyMappers.put(fieldName, (DynamicKeyFieldMapper)fieldMapper);
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            this.aliasToConcreteName.put(aliasName, path);
        }
        this.dynamicKeyLookup = new DynamicKeyFieldTypeLookup(dynamicKeyMappers, this.aliasToConcreteName);
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        MappedFieldType fieldType = this.fullNameToFieldType.get(concreteField);
        if (fieldType != null) {
            return fieldType;
        }
        return this.dynamicKeyLookup.get(field);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        Iterator<MappedFieldType> concreteFieldTypes = this.fullNameToFieldType.values().iterator();
        Iterator<MappedFieldType> keyedFieldTypes = this.dynamicKeyLookup.fieldTypes();
        return Iterators.concat(concreteFieldTypes, keyedFieldTypes);
    }
}

