/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.ShapeRelation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.SpatialStrategy;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Geometry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardException;

public abstract class AbstractGeometryFieldMapper<Parsed, Processed>
extends FieldMapper {
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    protected AbstractGeometryFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        AbstractGeometryFieldMapper gsfm = (AbstractGeometryFieldMapper)other;
        if (gsfm.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gsfm.ignoreMalformed;
        }
        if (gsfm.ignoreZValue.explicit()) {
            this.ignoreZValue = gsfm.ignoreZValue;
        }
    }

    @Override
    public AbstractGeometryFieldType fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void addStoredFields(ParseContext var1, Processed var2);

    protected abstract void addDocValuesFields(String var1, Processed var2, List<IndexableField> var3, ParseContext var4);

    protected abstract void addMultiFields(ParseContext var1, Processed var2) throws IOException;

    @Override
    public void parse(ParseContext context) throws IOException {
        AbstractGeometryFieldType mappedFieldType = this.fieldType();
        Indexer geometryIndexer = mappedFieldType.geometryIndexer();
        Parser geometryParser = mappedFieldType.geometryParser();
        try {
            Object shape = context.parseExternalValue(geometryIndexer.processedClass());
            if (shape == null) {
                Object geometry = geometryParser.parse(context.parser(), this);
                if (geometry == null) {
                    return;
                }
                shape = geometryIndexer.prepareForIndexing(geometry);
            }
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable() || mappedFieldType.hasDocValues()) {
                fields.addAll(geometryIndexer.indexShape(context, shape));
            }
            ArrayList<IndexableField> indexedFields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable()) {
                indexedFields.addAll(fields);
            }
            if (this.fieldType.stored()) {
                this.addStoredFields(context, shape);
            }
            if (this.fieldType().hasDocValues()) {
                this.addDocValuesFields(mappedFieldType.name(), shape, fields, context);
            } else if (this.fieldType.stored() || this.fieldType().isSearchable()) {
                this.createFieldNamesField(context);
            }
            for (IndexableField field : indexedFields) {
                context.doc().add(field);
            }
            this.addMultiFields(context, shape);
        }
        catch (Exception e) {
            if (!this.ignoreMalformed.value().booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(mappedFieldType.name());
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field(Names.IGNORE_MALFORMED.getPreferredName(), this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(Names.IGNORE_Z_VALUE.getPreferredName(), this.ignoreZValue.value());
        }
    }

    public Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    public static abstract class AbstractGeometryFieldType<Parsed, Processed>
    extends MappedFieldType {
        protected Indexer<Parsed, Processed> geometryIndexer;
        protected Parser<Parsed> geometryParser;
        protected QueryProcessor geometryQueryBuilder;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        public void setGeometryQueryBuilder(QueryProcessor geometryQueryBuilder) {
            this.geometryQueryBuilder = geometryQueryBuilder;
        }

        public void setGeometryIndexer(Indexer<Parsed, Processed> geometryIndexer) {
            this.geometryIndexer = geometryIndexer;
        }

        protected Indexer<Parsed, Processed> geometryIndexer() {
            return this.geometryIndexer;
        }

        public void setGeometryParser(Parser<Parsed> geometryParser) {
            this.geometryParser = geometryParser;
        }

        protected Parser<Parsed> geometryParser() {
            return this.geometryParser;
        }

        public QueryProcessor geometryQueryBuilder() {
            return this.geometryQueryBuilder;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]", new Object[0]);
        }

        public static interface QueryProcessor {
            public Query process(Geometry var1, String var2, ShapeRelation var3, QueryShardContext var4);

            @Deprecated
            default public Query process(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
                return this.process(shape, fieldName, relation, context);
            }
        }
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }

    public static interface Parser<Parsed> {
        public Parsed parse(XContentParser var1, AbstractGeometryFieldMapper var2) throws IOException, ParseException;
    }

    public static class Names {
        public static final ParseField IGNORE_MALFORMED = new ParseField("ignore_malformed", new String[0]);
        public static final ParseField IGNORE_Z_VALUE = new ParseField("ignore_z_value", new String[0]);
    }

    public static abstract class TypeParser<T extends Builder>
    implements Mapper.TypeParser {
        protected abstract T newBuilder(String var1, Map<String, Object> var2);

        public T parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Names.IGNORE_MALFORMED.match(propName, LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.IGNORE_MALFORMED.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (!Names.IGNORE_Z_VALUE.getPreferredName().equals(propName)) continue;
                params.put(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + "." + Names.IGNORE_Z_VALUE.getPreferredName()));
                iterator.remove();
            }
            T builder = this.newBuilder(name, params);
            if (params.containsKey(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName())) {
                ((Builder)builder).ignoreZValue((Boolean)params.get(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName()));
            }
            if (params.containsKey(Names.IGNORE_MALFORMED.getPreferredName())) {
                ((Builder)builder).ignoreMalformed((Boolean)params.get(Names.IGNORE_MALFORMED.getPreferredName()));
            }
            return builder;
        }

        public T parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            HashMap<String, Object> params = new HashMap<String, Object>();
            return this.parse(name, node, params, parserContext);
        }
    }

    public static abstract class Builder<T extends Builder<T, FT>, FT extends AbstractGeometryFieldType>
    extends FieldMapper.Builder<T> {
        protected Boolean ignoreMalformed;
        protected Boolean ignoreZValue;
        protected boolean indexed = true;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        public Builder(String name, FieldType fieldType, boolean ignoreMalformed, boolean ignoreZValue) {
            super(name, fieldType);
            this.ignoreMalformed = ignoreMalformed;
            this.ignoreZValue = ignoreZValue;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return this;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Explicit<Boolean> ignoreMalformed() {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue(Mapper.BuilderContext context) {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Explicit<Boolean> ignoreZValue() {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit<Boolean>(true, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

