/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.cache.bitset;

import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.metrics.CounterMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;

public class ShardBitsetFilterCache
extends AbstractIndexShardComponent {
    private final CounterMetric totalMetric = new CounterMetric();

    public ShardBitsetFilterCache(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }

    public long getMemorySizeInBytes() {
        return this.totalMetric.count();
    }
}

