/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util;

import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.LongArray;

public final class BitArray
implements Releasable {
    private final BigArrays bigArrays;
    private LongArray bits;

    public BitArray(int initialSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        this.bits = bigArrays.newLongArray(initialSize, true);
    }

    public void set(int index) {
        int wordNum = BitArray.wordNum(index);
        this.bits = this.bigArrays.grow(this.bits, (long)(wordNum + 1));
        this.bits.set(wordNum, this.bits.get(wordNum) | BitArray.bitmask(index));
    }

    public void clear(int index) {
        int wordNum = BitArray.wordNum(index);
        if ((long)wordNum >= this.bits.size()) {
            return;
        }
        this.bits.set(wordNum, this.bits.get(wordNum) & (BitArray.bitmask(index) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean get(int index) {
        int wordNum = BitArray.wordNum(index);
        if ((long)wordNum >= this.bits.size()) {
            return false;
        }
        long bitmask = 1L << index;
        return (this.bits.get(wordNum) & bitmask) != 0L;
    }

    private static int wordNum(int index) {
        return index >> 6;
    }

    private static long bitmask(int index) {
        return 1L << index;
    }

    @Override
    public void close() {
        Releasables.close(this.bits);
    }
}

