/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings;

import org.graylog.shaded.elasticsearch7.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.BaseKeyStoreCommand;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.SecureString;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.env.Environment;

class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword(terminal, true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configFile(), newPassword.getChars());
            terminal.println("Elasticsearch keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

