/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetRollupCapsRequest
implements Validatable,
ToXContentObject {
    private static final String ID = "id";
    private final String indexPattern;

    public GetRollupCapsRequest(String indexPattern) {
        this.indexPattern = Strings.isNullOrEmpty(indexPattern) || indexPattern.equals("*") ? "_all" : indexPattern;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID, this.indexPattern);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexPattern);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupCapsRequest other = (GetRollupCapsRequest)obj;
        return Objects.equals(this.indexPattern, other.indexPattern);
    }
}

