/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;

public final class CountRequest
extends ActionRequest
implements IndicesRequest.Replaceable,
ToXContentObject {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private String routing;
    private String preference;
    private QueryBuilder query;
    private IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
    private int terminateAfter = 0;
    private Float minScore;

    public CountRequest() {
    }

    public CountRequest(String ... indices) {
        this.indices(indices);
    }

    @Deprecated
    public CountRequest(String[] indices, SearchSourceBuilder searchSourceBuilder) {
        this.indices(indices);
        this.query = Objects.requireNonNull(searchSourceBuilder, "source must not be null").query();
    }

    public CountRequest(String[] indices, QueryBuilder query) {
        this.indices(indices);
        this.query = Objects.requireNonNull(query, "query must not be null");
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public CountRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Deprecated
    public CountRequest source(SearchSourceBuilder searchSourceBuilder) {
        this.query = Objects.requireNonNull(searchSourceBuilder, "source must not be null").query();
        return this;
    }

    public CountRequest query(QueryBuilder query) {
        this.query = Objects.requireNonNull(query, "query must not be null");
        return this;
    }

    @Deprecated
    public CountRequest types(String ... types) {
        Objects.requireNonNull(types, "types must not be null");
        for (String type : types) {
            Objects.requireNonNull(type, "type must not be null");
        }
        this.types = types;
        return this;
    }

    public CountRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public CountRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public CountRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    public CountRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public String[] indices() {
        return Arrays.copyOf(this.indices, this.indices.length);
    }

    public Float minScore() {
        return this.minScore;
    }

    public CountRequest minScore(Float minScore) {
        this.minScore = minScore;
        return this;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public CountRequest terminateAfter(int terminateAfter) {
        if (terminateAfter < 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfter;
        return this;
    }

    @Deprecated
    public String[] types() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    @Deprecated
    public SearchSourceBuilder source() {
        return new SearchSourceBuilder().query(this.query);
    }

    public QueryBuilder query() {
        return this.query;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.query != null) {
            builder.field("query", this.query);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountRequest that = (CountRequest)o;
        return Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices) && Arrays.equals(this.types, that.types) && Objects.equals(this.routing, that.routing) && Objects.equals(this.preference, that.preference) && Objects.equals(this.terminateAfter, that.terminateAfter) && Objects.equals(this.minScore, that.minScore) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.routing, this.preference, this.terminateAfter, this.minScore, this.query);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }
}

