/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Cancellable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestHighLevelClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.TasksRequestConverters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.tasks.CancelTasksRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.tasks.CancelTasksResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.tasks.GetTaskRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.tasks.GetTaskResponse;

public final class TasksClient {
    private final RestHighLevelClient restHighLevelClient;

    TasksClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ListTasksResponse list(ListTasksRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, TasksRequestConverters::listTasks, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable listAsync(ListTasksRequest request, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, TasksRequestConverters::listTasks, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public Optional<GetTaskResponse> get(GetTaskRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseOptionalEntity(request, TasksRequestConverters::getTask, options, GetTaskResponse::fromXContent);
    }

    public Cancellable getAsync(GetTaskRequest request, RequestOptions options, ActionListener<Optional<GetTaskResponse>> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseOptionalEntity(request, TasksRequestConverters::getTask, options, GetTaskResponse::fromXContent, listener);
    }

    public CancelTasksResponse cancel(CancelTasksRequest cancelTasksRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(cancelTasksRequest, TasksRequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable cancelAsync(CancelTasksRequest cancelTasksRequest, RequestOptions options, ActionListener<CancelTasksResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(cancelTasksRequest, TasksRequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, listener, Collections.emptySet());
    }
}

