/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.HandledTransportAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateObserver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.MasterNodeChangePredicate;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.NotMasterException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.NodeClosedException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeAction<Request extends MasterNodeRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportMasterNodeAction.class);
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String executor;

    protected TransportMasterNodeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        this(actionName, true, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver);
    }

    protected TransportMasterNodeAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, canTripCircuitBreaker, transportService, actionFilters, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = this.executor();
    }

    protected abstract String executor();

    protected abstract Response read(StreamInput var1) throws IOException;

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws Exception;

    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.masterOperation(request, state, listener);
    }

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, task, request, listener).start();
    }

    protected String getMasterActionName(DiscoveryNode node) {
        return this.actionName;
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private final Task task;
        final /* synthetic */ TransportMasterNodeAction this$0;

        AsyncSingleAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            if (task != null) {
                request.setParentTask(this$0.clusterService.localNode().getId(), task.getId());
            }
            this.listener = listener;
        }

        public void start() {
            ClusterState state = this.this$0.clusterService.state();
            this.observer = new ClusterStateObserver(state, this.this$0.clusterService, ((MasterNodeRequest)this.request).masterNodeTimeout(), logger, this.this$0.threadPool.getThreadContext());
            this.doStart(state);
        }

        protected void doStart(ClusterState clusterState) {
            try {
                final Predicate<ClusterState> masterChangePredicate = MasterNodeChangePredicate.build(clusterState);
                final DiscoveryNodes nodes = clusterState.nodes();
                if (nodes.isLocalNodeElectedMaster() || this.this$0.localExecute(this.request)) {
                    ClusterBlockException blockException = this.this$0.checkBlock(this.request, clusterState);
                    if (blockException != null) {
                        if (!blockException.retryable()) {
                            this.listener.onFailure(blockException);
                        } else {
                            logger.trace("can't execute due to a cluster block, retrying", (Throwable)blockException);
                            this.retry(blockException, newState -> {
                                try {
                                    ClusterBlockException newException = this.this$0.checkBlock(this.request, (ClusterState)newState);
                                    return newException == null || !newException.retryable();
                                }
                                catch (Exception e) {
                                    logger.trace("exception occurred during cluster block checking, accepting state", (Throwable)e);
                                    return true;
                                }
                            });
                        }
                    } else {
                        ActionListener delegate = ActionListener.delegateResponse(this.listener, (delegatedListener, t) -> {
                            if (t instanceof FailedToCommitClusterStateException || t instanceof NotMasterException) {
                                logger.debug(() -> new ParameterizedMessage("master could not publish cluster state or stepped down before publishing action [{}], scheduling a retry", (Object)this.this$0.actionName), (Throwable)t);
                                this.retry((Throwable)t, masterChangePredicate);
                            } else {
                                delegatedListener.onFailure((Exception)t);
                            }
                        });
                        this.this$0.threadPool.executor(this.this$0.executor).execute(ActionRunnable.wrap(delegate, l -> this.this$0.masterOperation(this.task, this.request, clusterState, l)));
                    }
                } else if (nodes.getMasterNode() == null) {
                    logger.debug("no known master node, scheduling a retry");
                    this.retry(null, masterChangePredicate);
                } else {
                    DiscoveryNode masterNode = nodes.getMasterNode();
                    final String actionName = this.this$0.getMasterActionName(masterNode);
                    this.this$0.transportService.sendRequest(masterNode, actionName, (TransportRequest)this.request, new ActionListenerResponseHandler<Response>(this.listener, this.this$0::read){

                        @Override
                        public void handleException(TransportException exp) {
                            Throwable cause = exp.unwrapCause();
                            if (cause instanceof ConnectTransportException || exp instanceof RemoteTransportException && cause instanceof NodeClosedException) {
                                logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", (Object)actionName, (Object)nodes.getMasterNode(), (Object)exp.getDetailedMessage());
                                AsyncSingleAction.this.retry(cause, masterChangePredicate);
                            } else {
                                AsyncSingleAction.this.listener.onFailure(exp);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        private void retry(final Throwable failure, Predicate<ClusterState> statePredicate) {
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    logger.debug(() -> new ParameterizedMessage("timed out while retrying [{}] after failure (timeout [{}])", (Object)AsyncSingleAction.this.this$0.actionName, (Object)timeout), failure);
                    AsyncSingleAction.this.listener.onFailure(new MasterNotDiscoveredException(failure));
                }
            }, statePredicate);
        }
    }
}

