/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.OriginalIndices;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;

public class GetFieldMappingsIndexRequest
extends SingleShardRequest<GetFieldMappingsIndexRequest> {
    private final boolean probablySingleFieldRequest;
    private final boolean includeDefaults;
    private final String[] fields;
    private final String[] types;
    private OriginalIndices originalIndices;

    GetFieldMappingsIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.types = in.readStringArray();
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
        this.probablySingleFieldRequest = in.readBoolean();
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    GetFieldMappingsIndexRequest(GetFieldMappingsRequest other, String index, boolean probablySingleFieldRequest) {
        this.probablySingleFieldRequest = probablySingleFieldRequest;
        this.includeDefaults = other.includeDefaults();
        this.types = other.types();
        this.fields = other.fields();
        assert (index != null);
        this.index(index);
        this.originalIndices = new OriginalIndices(other);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String[] types() {
        return this.types;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean probablySingleFieldRequest() {
        return this.probablySingleFieldRequest;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.types);
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
        out.writeBoolean(this.probablySingleFieldRequest);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

