/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BitDocIdSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.NotDocIdSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.RamUsageEstimator;

public class RoaringDocIdSet
extends DocIdSet {
    private static final int BLOCK_SIZE = 65536;
    private static final int MAX_ARRAY_LENGTH = 4096;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoaringDocIdSet.class);
    private final DocIdSet[] docIdSets;
    private final int cardinality;
    private final long ramBytesUsed;

    private RoaringDocIdSet(DocIdSet[] docIdSets, int cardinality) {
        this.docIdSets = docIdSets;
        long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf(docIdSets);
        for (DocIdSet set : this.docIdSets) {
            if (set == null) continue;
            ramBytesUsed += set.ramBytesUsed();
        }
        this.ramBytesUsed = ramBytesUsed;
        this.cardinality = cardinality;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        if (this.cardinality == 0) {
            return null;
        }
        return new Iterator();
    }

    public int cardinality() {
        return this.cardinality;
    }

    public String toString() {
        return "RoaringDocIdSet(cardinality=" + this.cardinality + ")";
    }

    private class Iterator
    extends DocIdSetIterator {
        int block = -1;
        DocIdSetIterator sub = DocIdSetIterator.empty();
        int doc = -1;

        Iterator() throws IOException {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            int subNext = this.sub.nextDoc();
            if (subNext == Integer.MAX_VALUE) {
                return this.firstDocFromNextBlock();
            }
            this.doc = this.block << 16 | subNext;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int subNext;
            int targetBlock = target >>> 16;
            if (targetBlock != this.block) {
                this.block = targetBlock;
                if (this.block >= RoaringDocIdSet.this.docIdSets.length) {
                    this.sub = null;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (RoaringDocIdSet.this.docIdSets[this.block] == null) {
                    return this.firstDocFromNextBlock();
                }
                this.sub = RoaringDocIdSet.this.docIdSets[this.block].iterator();
            }
            if ((subNext = this.sub.advance(target & 0xFFFF)) == Integer.MAX_VALUE) {
                return this.firstDocFromNextBlock();
            }
            this.doc = this.block << 16 | subNext;
            return this.doc;
        }

        private int firstDocFromNextBlock() throws IOException {
            do {
                ++this.block;
                if (this.block < RoaringDocIdSet.this.docIdSets.length) continue;
                this.sub = null;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (RoaringDocIdSet.this.docIdSets[this.block] == null);
            this.sub = RoaringDocIdSet.this.docIdSets[this.block].iterator();
            int subNext = this.sub.nextDoc();
            assert (subNext != Integer.MAX_VALUE);
            this.doc = this.block << 16 | subNext;
            return this.doc;
        }

        @Override
        public long cost() {
            return RoaringDocIdSet.this.cardinality;
        }
    }

    private static class ShortArrayDocIdSet
    extends DocIdSet {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ShortArrayDocIdSet.class);
        private final short[] docIDs;

        private ShortArrayDocIdSet(short[] docIDs) {
            this.docIDs = docIDs;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.docIDs);
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            return new DocIdSetIterator(){
                int i = -1;
                int doc = -1;

                private int docId(int i) {
                    return docIDs[i] & 0xFFFF;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (++this.i >= docIDs.length) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = this.docId(this.i);
                    return this.doc;
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return docIDs.length;
                }

                @Override
                public int advance(int target) throws IOException {
                    int lo = this.i + 1;
                    int hi = docIDs.length - 1;
                    while (lo <= hi) {
                        int mid = lo + hi >>> 1;
                        int midDoc = this.docId(mid);
                        if (midDoc < target) {
                            lo = mid + 1;
                            continue;
                        }
                        hi = mid - 1;
                    }
                    if (lo == docIDs.length) {
                        this.i = docIDs.length;
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.i = lo;
                    this.doc = this.docId(this.i);
                    return this.doc;
                }
            };
        }
    }

    public static class Builder {
        private final int maxDoc;
        private final DocIdSet[] sets;
        private int cardinality;
        private int lastDocId;
        private int currentBlock;
        private int currentBlockCardinality;
        private final short[] buffer;
        private FixedBitSet denseBuffer;

        public Builder(int maxDoc) {
            this.maxDoc = maxDoc;
            this.sets = new DocIdSet[maxDoc + 65536 - 1 >>> 16];
            this.lastDocId = -1;
            this.currentBlock = -1;
            this.buffer = new short[4096];
        }

        private void flush() {
            assert (this.currentBlockCardinality <= 65536);
            if (this.currentBlockCardinality <= 4096) {
                assert (this.denseBuffer == null);
                if (this.currentBlockCardinality > 0) {
                    this.sets[this.currentBlock] = new ShortArrayDocIdSet(ArrayUtil.copyOfSubArray(this.buffer, 0, this.currentBlockCardinality));
                }
            } else {
                assert (this.denseBuffer != null);
                assert (this.denseBuffer.cardinality() == this.currentBlockCardinality);
                if (this.denseBuffer.length() == 65536 && 65536 - this.currentBlockCardinality < 4096) {
                    short[] excludedDocs = new short[65536 - this.currentBlockCardinality];
                    this.denseBuffer.flip(0, this.denseBuffer.length());
                    int excludedDoc = -1;
                    for (int i = 0; i < excludedDocs.length; ++i) {
                        excludedDoc = this.denseBuffer.nextSetBit(excludedDoc + 1);
                        assert (excludedDoc != Integer.MAX_VALUE);
                        excludedDocs[i] = (short)excludedDoc;
                    }
                    assert (excludedDoc + 1 == this.denseBuffer.length() || this.denseBuffer.nextSetBit(excludedDoc + 1) == Integer.MAX_VALUE);
                    this.sets[this.currentBlock] = new NotDocIdSet(65536, new ShortArrayDocIdSet(excludedDocs));
                } else {
                    this.sets[this.currentBlock] = new BitDocIdSet(this.denseBuffer, this.currentBlockCardinality);
                }
                this.denseBuffer = null;
            }
            this.cardinality += this.currentBlockCardinality;
            this.denseBuffer = null;
            this.currentBlockCardinality = 0;
        }

        public Builder add(int docId) {
            if (docId <= this.lastDocId) {
                throw new IllegalArgumentException("Doc ids must be added in-order, got " + docId + " which is <= lastDocID=" + this.lastDocId);
            }
            int block = docId >>> 16;
            if (block != this.currentBlock) {
                this.flush();
                this.currentBlock = block;
            }
            if (this.currentBlockCardinality < 4096) {
                this.buffer[this.currentBlockCardinality] = (short)docId;
            } else {
                if (this.denseBuffer == null) {
                    int numBits = Math.min(65536, this.maxDoc - (block << 16));
                    this.denseBuffer = new FixedBitSet(numBits);
                    for (short doc : this.buffer) {
                        this.denseBuffer.set(doc & 0xFFFF);
                    }
                }
                this.denseBuffer.set(docId & 0xFFFF);
            }
            this.lastDocId = docId;
            ++this.currentBlockCardinality;
            return this;
        }

        public Builder add(DocIdSetIterator disi) throws IOException {
            int doc = disi.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.add(doc);
                doc = disi.nextDoc();
            }
            return this;
        }

        public RoaringDocIdSet build() {
            this.flush();
            return new RoaringDocIdSet(this.sets, this.cardinality);
        }
    }
}

