/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.PlanetModel;

public class LinearSquaredDistance
implements DistanceStyle {
    public static final LinearSquaredDistance INSTANCE = new LinearSquaredDistance();

    @Override
    public double computeDistance(GeoPoint point1, GeoPoint point2) {
        return point1.linearDistanceSquared(point2);
    }

    @Override
    public double computeDistance(GeoPoint point1, double x2, double y2, double z2) {
        return point1.linearDistanceSquared(x2, y2, z2);
    }

    @Override
    public double computeDistance(PlanetModel planetModel, Plane plane, GeoPoint point, Membership ... bounds) {
        return plane.linearDistanceSquared(planetModel, point, bounds);
    }

    @Override
    public double computeDistance(PlanetModel planetModel, Plane plane, double x, double y, double z, Membership ... bounds) {
        return plane.linearDistanceSquared(planetModel, x, y, z, bounds);
    }

    @Override
    public double toAggregationForm(double distance) {
        return Math.sqrt(distance);
    }

    @Override
    public double fromAggregationForm(double aggregateDistance) {
        return aggregateDistance * aggregateDistance;
    }

    @Override
    public GeoPoint[] findDistancePoints(PlanetModel planetModel, double distanceValue, GeoPoint startPoint, Plane plane, Membership ... bounds) {
        throw new IllegalStateException("Reverse mapping not implemented for this distance metric");
    }

    @Override
    public double findMinimumArcDistance(PlanetModel planetModel, double distanceValue) {
        throw new IllegalStateException("Reverse mapping not implemented for this distance metric");
    }

    @Override
    public double findMaximumArcDistance(PlanetModel planetModel, double distanceValue) {
        throw new IllegalStateException("Reverse mapping not implemented for this distance metric");
    }
}

