/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Vector;

class GeoLatitudeZone
extends GeoBaseBBox {
    protected final double topLat;
    protected final double bottomLat;
    protected final double cosTopLat;
    protected final double cosBottomLat;
    protected final SidedPlane topPlane;
    protected final SidedPlane bottomPlane;
    protected final GeoPoint interiorPoint;
    protected static final GeoPoint[] planePoints = new GeoPoint[0];
    protected final GeoPoint topBoundaryPoint;
    protected final GeoPoint bottomBoundaryPoint;
    protected final GeoPoint[] edgePoints;

    public GeoLatitudeZone(PlanetModel planetModel, double topLat, double bottomLat) {
        super(planetModel);
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        double sinTopLat = Math.sin(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        this.cosTopLat = Math.cos(topLat);
        this.cosBottomLat = Math.cos(bottomLat);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(planetModel, sinMiddleLat, 0.0, Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 1.0);
        this.topBoundaryPoint = new GeoPoint(planetModel, sinTopLat, 0.0, Math.sqrt(1.0 - sinTopLat * sinTopLat), 1.0);
        this.bottomBoundaryPoint = new GeoPoint(planetModel, sinBottomLat, 0.0, Math.sqrt(1.0 - sinBottomLat * sinBottomLat), 1.0);
        this.topPlane = new SidedPlane((Vector)this.interiorPoint, planetModel, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.interiorPoint, planetModel, sinBottomLat);
        this.edgePoints = new GeoPoint[]{this.topBoundaryPoint, this.bottomBoundaryPoint};
    }

    public GeoLatitudeZone(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.topLat);
        SerializableObject.writeDouble(outputStream, this.bottomLat);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.topLat > 0.0 && this.bottomLat < 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosTopLat;
        if (maxCosLat < this.cosBottomLat) {
            maxCosLat = this.cosBottomLat;
        }
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.topPlane, notablePoints, planePoints, bounds, this.bottomPlane) || p.intersects(this.planetModel, this.bottomPlane, notablePoints, planePoints, bounds, this.topPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.topPlane, planePoints, this.bottomPlane) || geoShape.intersects(this.bottomPlane, planePoints, this.topPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.noLongitudeBound().addHorizontalPlane(this.planetModel, this.topLat, this.topPlane, new Membership[0]).addHorizontalPlane(this.planetModel, this.bottomLat, this.bottomPlane, new Membership[0]);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double topDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.topPlane, x, y, z, this.bottomPlane);
        double bottomDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.bottomPlane, x, y, z, this.topPlane);
        return Math.min(topDistance, bottomDistance);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoLatitudeZone)) {
            return false;
        }
        GeoLatitudeZone other = (GeoLatitudeZone)o;
        return super.equals(other) && other.topBoundaryPoint.equals(this.topBoundaryPoint) && other.bottomBoundaryPoint.equals(this.bottomBoundaryPoint);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.topBoundaryPoint.hashCode();
        result = 31 * result + this.bottomBoundaryPoint.hashCode();
        return result;
    }

    public String toString() {
        return "GeoLatitudeZone: {planetmodel=" + this.planetModel + ", toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

