/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d;

import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Polygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoCircle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoCircleFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoCompositePolygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPath;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPathFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPolygonFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.PlanetModel;

class Geo3DUtil {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;

    Geo3DUtil() {
    }

    static double decodeValueFloor(int x, PlanetModel planetModel) {
        assert (x <= planetModel.MAX_ENCODED_VALUE && x >= planetModel.MIN_ENCODED_VALUE);
        if (x == planetModel.MIN_ENCODED_VALUE) {
            return -planetModel.MAX_VALUE;
        }
        return (double)x * planetModel.DECODE;
    }

    static double decodeValueCeil(int x, PlanetModel planetModel) {
        assert (x <= planetModel.MAX_ENCODED_VALUE && x >= planetModel.MIN_ENCODED_VALUE);
        if (x == planetModel.MAX_ENCODED_VALUE) {
            return planetModel.MAX_VALUE;
        }
        return Math.nextDown((double)(x + 1) * planetModel.DECODE);
    }

    static double fromDegrees(double degrees) {
        return degrees * (Math.PI / 180);
    }

    static GeoPolygon fromPolygon(PlanetModel planetModel, Polygon ... polygons) {
        GeoPolygon shape;
        if (polygons.length < 1) {
            throw new IllegalArgumentException("need at least one polygon");
        }
        if (polygons.length == 1) {
            GeoPolygon component = Geo3DUtil.fromPolygon(planetModel, polygons[0]);
            shape = component == null ? new GeoCompositePolygon(planetModel) : component;
        } else {
            GeoCompositePolygon poly = new GeoCompositePolygon(planetModel);
            for (Polygon p : polygons) {
                GeoPolygon component = Geo3DUtil.fromPolygon(planetModel, p);
                if (component == null) continue;
                poly.addShape(component);
            }
            shape = poly;
        }
        return shape;
    }

    static GeoPolygon fromLargePolygon(PlanetModel planetModel, Polygon ... polygons) {
        if (polygons.length < 1) {
            throw new IllegalArgumentException("need at least one polygon");
        }
        return GeoPolygonFactory.makeLargeGeoPolygon(planetModel, Geo3DUtil.convertToDescription(planetModel, polygons));
    }

    static GeoPath fromPath(PlanetModel planetModel, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters) {
        if (pathLatitudes.length != pathLongitudes.length) {
            throw new IllegalArgumentException("same number of latitudes and longitudes required");
        }
        GeoPoint[] points = new GeoPoint[pathLatitudes.length];
        for (int i = 0; i < pathLatitudes.length; ++i) {
            double latitude = pathLatitudes[i];
            double longitude = pathLongitudes[i];
            GeoUtils.checkLatitude(latitude);
            GeoUtils.checkLongitude(longitude);
            points[i] = new GeoPoint(planetModel, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude));
        }
        double radiusRadians = pathWidthMeters / (planetModel.getMeanRadius() * planetModel.xyScaling);
        return GeoPathFactory.makeGeoPath(planetModel, radiusRadians, points);
    }

    static GeoCircle fromDistance(PlanetModel planetModel, double latitude, double longitude, double radiusMeters) {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        double radiusRadians = radiusMeters / planetModel.getMeanRadius();
        return GeoCircleFactory.makeGeoCircle(planetModel, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude), radiusRadians);
    }

    static GeoBBox fromBox(PlanetModel planetModel, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoUtils.checkLatitude(minLatitude);
        GeoUtils.checkLongitude(minLongitude);
        GeoUtils.checkLatitude(maxLatitude);
        GeoUtils.checkLongitude(maxLongitude);
        return GeoBBoxFactory.makeGeoBBox(planetModel, Geo3DUtil.fromDegrees(maxLatitude), Geo3DUtil.fromDegrees(minLatitude), Geo3DUtil.fromDegrees(minLongitude), Geo3DUtil.fromDegrees(maxLongitude));
    }

    private static GeoPolygon fromPolygon(PlanetModel planetModel, Polygon polygon) {
        Polygon[] theHoles = polygon.getHoles();
        ArrayList<GeoPolygon> holeList = new ArrayList<GeoPolygon>(theHoles.length);
        for (Polygon hole : theHoles) {
            GeoPolygon component = Geo3DUtil.fromPolygon(planetModel, hole);
            if (component == null) continue;
            holeList.add(component);
        }
        double[] polyLats = polygon.getPolyLats();
        double[] polyLons = polygon.getPolyLons();
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(polyLats.length - 1);
        for (int i = 0; i < polyLats.length - 1; ++i) {
            int index = polyLats.length - 2 - i;
            points.add(new GeoPoint(planetModel, Geo3DUtil.fromDegrees(polyLats[index]), Geo3DUtil.fromDegrees(polyLons[index])));
        }
        GeoPolygon rval = GeoPolygonFactory.makeGeoPolygon(planetModel, points, holeList);
        return rval;
    }

    private static List<GeoPolygonFactory.PolygonDescription> convertToDescription(PlanetModel planetModel, Polygon ... polygons) {
        ArrayList<GeoPolygonFactory.PolygonDescription> descriptions = new ArrayList<GeoPolygonFactory.PolygonDescription>(polygons.length);
        for (Polygon polygon : polygons) {
            Polygon[] theHoles = polygon.getHoles();
            List<GeoPolygonFactory.PolygonDescription> holes = Geo3DUtil.convertToDescription(planetModel, theHoles);
            double[] polyLats = polygon.getPolyLats();
            double[] polyLons = polygon.getPolyLons();
            ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(polyLats.length - 1);
            for (int i = 0; i < polyLats.length - 1; ++i) {
                int index = polyLats.length - 2 - i;
                points.add(new GeoPoint(planetModel, Geo3DUtil.fromDegrees(polyLats[index]), Geo3DUtil.fromDegrees(polyLons[index])));
            }
            descriptions.add(new GeoPolygonFactory.PolygonDescription(points, holes));
        }
        return descriptions;
    }
}

