/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Impacts;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.ImpactsSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MaxScoreCache;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.Similarity;

public final class ImpactsDISI
extends DocIdSetIterator {
    private final DocIdSetIterator in;
    private final ImpactsSource impactsSource;
    private final MaxScoreCache maxScoreCache;
    private final float globalMaxScore;
    private float minCompetitiveScore = 0.0f;
    private int upTo = Integer.MAX_VALUE;
    private float maxScore = Float.MAX_VALUE;

    public ImpactsDISI(DocIdSetIterator in, ImpactsSource impactsSource, Similarity.SimScorer scorer) {
        this.in = in;
        this.impactsSource = impactsSource;
        this.maxScoreCache = new MaxScoreCache(impactsSource, scorer);
        this.globalMaxScore = scorer.score(Float.MAX_VALUE, 1L);
    }

    public void setMinCompetitiveScore(float minCompetitiveScore) {
        assert (minCompetitiveScore >= this.minCompetitiveScore);
        if (minCompetitiveScore > this.minCompetitiveScore) {
            this.minCompetitiveScore = minCompetitiveScore;
            this.upTo = -1;
        }
    }

    public int advanceShallow(int target) throws IOException {
        this.impactsSource.advanceShallow(target);
        Impacts impacts = this.impactsSource.getImpacts();
        return impacts.getDocIdUpTo(0);
    }

    public float getMaxScore(int upTo) throws IOException {
        int level = this.maxScoreCache.getLevel(upTo);
        if (level == -1) {
            return this.globalMaxScore;
        }
        return this.maxScoreCache.getMaxScoreForLevel(level);
    }

    private int advanceTarget(int target) throws IOException {
        if (target <= this.upTo) {
            return target;
        }
        this.upTo = this.advanceShallow(target);
        this.maxScore = this.maxScoreCache.getMaxScoreForLevel(0);
        while (true) {
            assert (this.upTo >= target);
            if (this.maxScore >= this.minCompetitiveScore) {
                return target;
            }
            if (this.upTo == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int skipUpTo = this.maxScoreCache.getSkipUpTo(this.minCompetitiveScore);
            if (skipUpTo == -1) {
                target = this.upTo + 1;
            } else {
                if (skipUpTo == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                target = skipUpTo + 1;
            }
            this.upTo = this.advanceShallow(target);
            this.maxScore = this.maxScoreCache.getMaxScoreForLevel(0);
        }
    }

    @Override
    public int advance(int target) throws IOException {
        return this.in.advance(this.advanceTarget(target));
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.in.docID() + 1);
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

