/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValuesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;

public final class DocValuesFieldExistsQuery
extends Query {
    private final String field;

    public DocValuesFieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((DocValuesFieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "DocValuesFieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator iterator = DocValuesFieldExistsQuery.getDocValuesDocIdSetIterator(DocValuesFieldExistsQuery.this.field, context.reader());
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, DocValuesFieldExistsQuery.this.field);
            }
        };
    }

    public static DocIdSetIterator getDocValuesDocIdSetIterator(String field, LeafReader reader) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo != null) {
            DocValuesIterator iterator;
            switch (fieldInfo.getDocValuesType()) {
                case NONE: {
                    iterator = null;
                    break;
                }
                case NUMERIC: {
                    iterator = reader.getNumericDocValues(field);
                    break;
                }
                case BINARY: {
                    iterator = reader.getBinaryDocValues(field);
                    break;
                }
                case SORTED: {
                    iterator = reader.getSortedDocValues(field);
                    break;
                }
                case SORTED_NUMERIC: {
                    iterator = reader.getSortedNumericDocValues(field);
                    break;
                }
                case SORTED_SET: {
                    iterator = reader.getSortedSetDocValues(field);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return iterator;
        }
        return null;
    }
}

