/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisiPriorityQueue;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LongValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;

final class CoveringScorer
extends Scorer {
    final int numScorers;
    final int maxDoc;
    final LongValues minMatchValues;
    boolean matches;
    int doc;
    DisiWrapper topList;
    int freq;
    long minMatch;
    final DisiPriorityQueue subScorers;
    final long cost;
    private final DocIdSetIterator approximation = new DocIdSetIterator(){

        @Override
        public int docID() {
            return CoveringScorer.this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            CoveringScorer.this.matches = false;
            CoveringScorer.this.topList = null;
            CoveringScorer.this.doc = target;
            this.setMinMatch();
            DisiWrapper top = CoveringScorer.this.subScorers.top();
            int numMatches = 0;
            int maxPotentialMatches = CoveringScorer.this.numScorers;
            while (top.doc < target) {
                if ((long)maxPotentialMatches < CoveringScorer.this.minMatch) {
                    CoveringScorer.this.doc = target >= CoveringScorer.this.maxDoc - 1 ? Integer.MAX_VALUE : target + 1;
                    this.setMinMatch();
                    return CoveringScorer.this.doc;
                }
                top.doc = top.iterator.advance(target);
                boolean match = top.doc == target;
                top = CoveringScorer.this.subScorers.updateTop();
                if (match) {
                    if ((long)(++numMatches) < CoveringScorer.this.minMatch) continue;
                    CoveringScorer.this.matches = true;
                    return CoveringScorer.this.doc;
                }
                --maxPotentialMatches;
            }
            CoveringScorer.this.doc = top.doc;
            this.setMinMatch();
            return CoveringScorer.this.doc;
        }

        private void setMinMatch() throws IOException {
            CoveringScorer.this.minMatch = CoveringScorer.this.doc >= CoveringScorer.this.maxDoc ? 1L : (CoveringScorer.this.minMatchValues.advanceExact(CoveringScorer.this.doc) ? Math.max(1L, CoveringScorer.this.minMatchValues.longValue()) : Long.MAX_VALUE);
        }

        @Override
        public long cost() {
            return CoveringScorer.this.maxDoc;
        }
    };
    private final TwoPhaseIterator twoPhase = new TwoPhaseIterator(this.approximation){

        @Override
        public boolean matches() throws IOException {
            if (CoveringScorer.this.matches) {
                return true;
            }
            if (CoveringScorer.this.topList == null) {
                CoveringScorer.this.advanceAll(CoveringScorer.this.doc);
            }
            if (CoveringScorer.this.subScorers.top().doc != CoveringScorer.this.doc) {
                assert (CoveringScorer.this.subScorers.top().doc > CoveringScorer.this.doc);
                return false;
            }
            CoveringScorer.this.setTopListAndFreq();
            assert (CoveringScorer.this.topList.doc == CoveringScorer.this.doc);
            CoveringScorer.this.matches = (long)CoveringScorer.this.freq >= CoveringScorer.this.minMatch;
            return CoveringScorer.this.matches;
        }

        @Override
        public float matchCost() {
            return CoveringScorer.this.numScorers;
        }
    };

    CoveringScorer(Weight weight, Collection<Scorer> scorers, LongValues minMatchValues, int maxDoc) {
        super(weight);
        this.numScorers = scorers.size();
        this.maxDoc = maxDoc;
        this.minMatchValues = minMatchValues;
        this.doc = -1;
        this.subScorers = new DisiPriorityQueue(scorers.size());
        for (Scorer scorer : scorers) {
            this.subScorers.add(new DisiWrapper(scorer));
        }
        this.cost = scorers.stream().map(Scorer::iterator).mapToLong(DocIdSetIterator::cost).sum();
    }

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() throws IOException {
        ArrayList<Scorable.ChildScorable> matchingChildren = new ArrayList<Scorable.ChildScorable>();
        this.setTopListAndFreqIfNecessary();
        DisiWrapper s = this.topList;
        while (s != null) {
            matchingChildren.add(new Scorable.ChildScorable(s.scorer, "SHOULD"));
            s = s.next;
        }
        return matchingChildren;
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    private void advanceAll(int target) throws IOException {
        DisiWrapper top = this.subScorers.top();
        while (top.doc < target) {
            top.doc = top.iterator.advance(target);
            top = this.subScorers.updateTop();
        }
    }

    private void setTopListAndFreq() {
        this.topList = this.subScorers.topList();
        this.freq = 0;
        DisiWrapper w = this.topList;
        while (w != null) {
            ++this.freq;
            w = w.next;
        }
    }

    private void setTopListAndFreqIfNecessary() throws IOException {
        if (this.topList == null) {
            this.advanceAll(this.doc);
            this.setTopListAndFreq();
        }
    }

    @Override
    public float score() throws IOException {
        this.setTopListAndFreqIfNecessary();
        double score = 0.0;
        DisiWrapper w = this.topList;
        while (w != null) {
            score += (double)w.scorer.score();
            w = w.next;
        }
        return (float)score;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public int docID() {
        return this.doc;
    }
}

