/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.CachingMatchesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchesUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;

class MinimizingConjunctionMatchesIterator
implements IntervalMatchesIterator {
    final IntervalIterator iterator;
    private final List<CachingMatchesIterator> subs = new ArrayList<CachingMatchesIterator>();
    private boolean cached = true;

    MinimizingConjunctionMatchesIterator(IntervalIterator iterator, List<IntervalMatchesIterator> subs) {
        this.iterator = iterator;
        for (MatchesIterator matchesIterator : subs) {
            assert (matchesIterator instanceof CachingMatchesIterator);
            this.subs.add((CachingMatchesIterator)matchesIterator);
        }
    }

    @Override
    public boolean next() throws IOException {
        if (this.cached) {
            this.cached = false;
            return true;
        }
        return this.iterator.nextInterval() != Integer.MAX_VALUE;
    }

    @Override
    public int startPosition() {
        return this.iterator.start();
    }

    @Override
    public int endPosition() {
        return this.iterator.end();
    }

    @Override
    public int startOffset() throws IOException {
        int start = Integer.MAX_VALUE;
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            start = Math.min(start, s.startOffset(endPos));
        }
        return start;
    }

    @Override
    public int endOffset() throws IOException {
        int end = 0;
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            end = Math.max(end, s.endOffset(endPos));
        }
        return end;
    }

    @Override
    public int gaps() {
        return this.iterator.gaps();
    }

    @Override
    public int width() {
        return this.iterator.width();
    }

    @Override
    public MatchesIterator getSubMatches() throws IOException {
        ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
        int endPos = this.endPosition();
        for (CachingMatchesIterator s : this.subs) {
            mis.add(s.getSubMatches(endPos));
        }
        return MatchesUtils.disjunction(mis);
    }

    @Override
    public Query getQuery() {
        return null;
    }
}

