/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocIDMerger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.MultiPostingsEnum;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;

final class MappingMultiPostingsEnum
extends PostingsEnum {
    MultiPostingsEnum multiDocsAndPositionsEnum;
    final String field;
    final DocIDMerger<MappingPostingsSub> docIDMerger;
    private MappingPostingsSub current;
    private final MappingPostingsSub[] allSubs;
    private final List<MappingPostingsSub> subs = new ArrayList<MappingPostingsSub>();

    public MappingMultiPostingsEnum(String field, MergeState mergeState) throws IOException {
        this.field = field;
        this.allSubs = new MappingPostingsSub[mergeState.fieldsProducers.length];
        for (int i = 0; i < this.allSubs.length; ++i) {
            this.allSubs[i] = new MappingPostingsSub(mergeState.docMaps[i]);
        }
        this.docIDMerger = DocIDMerger.of(this.subs, this.allSubs.length, mergeState.needsIndexSort);
    }

    MappingMultiPostingsEnum reset(MultiPostingsEnum postingsEnum) throws IOException {
        this.multiDocsAndPositionsEnum = postingsEnum;
        MultiPostingsEnum.EnumWithSlice[] subsArray = postingsEnum.getSubs();
        int count = postingsEnum.getNumSubs();
        this.subs.clear();
        for (int i = 0; i < count; ++i) {
            MappingPostingsSub sub = this.allSubs[subsArray[i].slice.readerIndex];
            sub.postings = subsArray[i].postingsEnum;
            this.subs.add(sub);
        }
        this.docIDMerger.reset();
        return this;
    }

    @Override
    public int freq() throws IOException {
        return this.current.postings.freq();
    }

    @Override
    public int docID() {
        if (this.current == null) {
            return -1;
        }
        return this.current.mappedDocID;
    }

    @Override
    public int advance(int target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextDoc() throws IOException {
        this.current = this.docIDMerger.next();
        if (this.current == null) {
            return Integer.MAX_VALUE;
        }
        return this.current.mappedDocID;
    }

    @Override
    public int nextPosition() throws IOException {
        int pos = this.current.postings.nextPosition();
        if (pos < 0) {
            throw new CorruptIndexException("position=" + pos + " is negative, field=\"" + this.field + " doc=" + this.current.mappedDocID, this.current.postings.toString());
        }
        if (pos > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + pos + " is too large (> IndexWriter.MAX_POSITION=" + 0x7FFFFF7F + "), field=\"" + this.field + "\" doc=" + this.current.mappedDocID, this.current.postings.toString());
        }
        return pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.postings.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.postings.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.postings.getPayload();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (MappingPostingsSub sub : this.subs) {
            cost += sub.postings.cost();
        }
        return cost;
    }

    private static class MappingPostingsSub
    extends DocIDMerger.Sub {
        public PostingsEnum postings;

        public MappingPostingsSub(MergeState.DocMap docMap) {
            super(docMap);
        }

        @Override
        public int nextDoc() {
            try {
                return this.postings.nextDoc();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

