/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.geo;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Circle2D;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYGeometry;

public final class XYCircle
extends XYGeometry {
    private final float x;
    private final float y;
    private final float radius;

    public XYCircle(float x, float y, float radius) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be bigger than 0, got " + radius);
        }
        if (!Float.isFinite(radius)) {
            throw new IllegalArgumentException("radius must be finite, got " + radius);
        }
        this.x = XYEncodingUtils.checkVal(x);
        this.y = XYEncodingUtils.checkVal(y);
        this.radius = radius;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    protected Component2D toComponent2D() {
        return Circle2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYCircle)) {
            return false;
        }
        XYCircle circle = (XYCircle)o;
        return this.x == circle.x && this.y == circle.y && this.radius == circle.radius;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        result = 31 * result + Float.hashCode(this.radius);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CIRCLE(");
        sb.append("[" + this.x + "," + this.y + "]");
        sb.append(" radius = " + this.radius);
        sb.append(')');
        return sb.toString();
    }
}

