/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.tdunning.math.stats;

public abstract class Histogram {
    public Histogram(double min, double max, double binsPerDecade) {
        if (max <= 2.0 * min) {
            throw new IllegalArgumentException(String.format("Illegal/nonsensical min,max (%.2f, %.2g)", min, max));
        }
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("Min and max must be positive");
        }
        if (binsPerDecade < 5.0 || binsPerDecade > 10000.0) {
            throw new IllegalArgumentException(String.format("Unreasonable number of bins per decade %.2g. Expected value in range [5,10000]", binsPerDecade));
        }
    }

    abstract void add(double var1);

    abstract double[] getBounds();

    abstract long[] getCounts();

    abstract long[] getCompressedCounts();
}

