/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.transports;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import org.graylog.aws.AWS;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.auth.AWSAuthProvider;
import org.graylog.aws.config.AWSPluginConfiguration;
import org.graylog.aws.inputs.transports.KinesisTransportState;
import org.graylog.aws.kinesis.KinesisConsumer;
import org.graylog2.Configuration;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisTransport
extends ThrottleableTransport {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisTransport.class);
    public static final String NAME = "awskinesis";
    private static final String CK_AWS_REGION = "aws_region";
    private static final String CK_ACCESS_KEY = "aws_access_key";
    private static final String CK_SECRET_KEY = "aws_secret_key";
    private static final String CK_ASSUME_ROLE_ARN = "aws_assume_role_arn";
    private static final String CK_KINESIS_STREAM_NAME = "kinesis_stream_name";
    private static final String CK_KINESIS_RECORD_BATCH_SIZE = "kinesis_record_batch_size";
    private static final String CK_KINESIS_MAX_THROTTLED_WAIT_MS = "kinesis_max_throttled_wait";
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private static final int DEFAULT_THROTTLED_WAIT_MS = 60000;
    private static final int KINESIS_CONSUMER_STOP_WAIT_MS = 15000;
    private final org.graylog2.plugin.configuration.Configuration configuration;
    private final Configuration graylogConfiguration;
    private final NodeId nodeId;
    private final LocalMetricRegistry localRegistry;
    private final ClusterConfigService clusterConfigService;
    private final ObjectMapper objectMapper;
    private KinesisConsumer reader;
    private final ExecutorService executor;
    private Future<?> kinesisTaskFuture = null;
    public AtomicBoolean stoppedDueToThrottling;
    public final AtomicReference<KinesisTransportState> consumerState;

    @Inject
    public KinesisTransport(@Assisted org.graylog2.plugin.configuration.Configuration configuration, EventBus serverEventBus, Configuration graylogConfiguration, ClusterConfigService clusterConfigService, NodeId nodeId, LocalMetricRegistry localRegistry, @AWSObjectMapper ObjectMapper objectMapper) {
        super(serverEventBus, configuration);
        this.clusterConfigService = clusterConfigService;
        this.configuration = configuration;
        this.graylogConfiguration = graylogConfiguration;
        this.nodeId = nodeId;
        this.localRegistry = localRegistry;
        this.objectMapper = objectMapper;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("aws-kinesis-reader-%d").setUncaughtExceptionHandler((t, e) -> LOG.error("Uncaught exception in AWS Kinesis reader.", e)).build());
        this.stoppedDueToThrottling = new AtomicBoolean(false);
        this.consumerState = new AtomicReference<KinesisTransportState>(KinesisTransportState.STOPPED);
    }

    public void handleChangedThrottledState(boolean isThrottled) {
        if (!isThrottled) {
            LOG.info("Unthrottled");
        } else {
            LOG.info("Throttled");
        }
        if (!isThrottled && this.stoppedDueToThrottling.get()) {
            this.stoppedDueToThrottling.set(false);
            LOG.debug("Transport state [{}]", (Object)this.consumerState.get());
            switch (this.consumerState.get()) {
                case STOPPED: {
                    LOG.info("[unthrottled] Throttle state ended restarting consumer");
                    this.restartConsumer();
                    break;
                }
                case STOPPING: {
                    LOG.info("Kinesis consumer is still stopping. Waiting [{}ms] for the consumer to finish stopping before restarting.", (Object)15000);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (KinesisTransport.this.consumerState.get() == KinesisTransportState.STOPPED) {
                                KinesisTransport.this.restartConsumer();
                            } else {
                                LOG.error("Could not restart Kinesis consumer, because the previously running consumer did not reach a STOPPED state within [{}ms].", (Object)15000);
                            }
                        }
                    }, 15000L);
                }
            }
        }
    }

    private void restartConsumer() {
        this.kinesisTaskFuture = this.executor.submit(this.reader);
    }

    public void doLaunch(MessageInput input) throws MisfireException {
        AWSPluginConfiguration awsConfig = (AWSPluginConfiguration)this.clusterConfigService.getOrDefault(AWSPluginConfiguration.class, (Object)AWSPluginConfiguration.createDefault());
        AWSAuthProvider authProvider = new AWSAuthProvider(this.graylogConfiguration, awsConfig, this.configuration.getString(CK_ACCESS_KEY), this.configuration.getString(CK_SECRET_KEY), this.configuration.getString(CK_AWS_REGION), this.configuration.getString(CK_ASSUME_ROLE_ARN));
        this.reader = new KinesisConsumer(this.configuration.getString(CK_KINESIS_STREAM_NAME), Region.getRegion(Regions.fromName(this.configuration.getString(CK_AWS_REGION))), this.kinesisCallback(input), awsConfig, authProvider, this.nodeId, this.graylogConfiguration.getHttpProxyUri() == null ? null : HttpUrl.get((URI)this.graylogConfiguration.getHttpProxyUri()), this, this.objectMapper, this.configuration.intIsSet(CK_KINESIS_MAX_THROTTLED_WAIT_MS) ? Integer.valueOf(this.configuration.getInt(CK_KINESIS_MAX_THROTTLED_WAIT_MS)) : null, this.configuration.getInt(CK_KINESIS_RECORD_BATCH_SIZE, 10000));
        LOG.info("Starting Kinesis reader thread for input [{}/{}]", (Object)input.getName(), (Object)input.getId());
        this.kinesisTaskFuture = this.executor.submit(this.reader);
    }

    private Consumer<byte[]> kinesisCallback(MessageInput input) {
        return data -> input.processRawMessage(new RawMessage(data));
    }

    public void doStop() {
        this.stoppedDueToThrottling.set(false);
        if (this.reader != null) {
            this.reader.stop();
        }
    }

    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    public MetricSet getMetricSet() {
        return this.localRegistry;
    }

    @ConfigClass
    public static class Config
    extends ThrottleableTransport.Config {
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField((ConfigurationField)new NumberField(KinesisTransport.CK_KINESIS_MAX_THROTTLED_WAIT_MS, "Throttled wait milliseconds", 60000, "The maximum time that the Kinesis input will pause for when in a throttled state. If this time is exceeded, then the Kinesis consumer will shut down until the throttled state is cleared. Recommended default: 60,000 ms", ConfigurationField.Optional.OPTIONAL, new NumberField.Attribute[]{NumberField.Attribute.ONLY_POSITIVE}));
            r.addField((ConfigurationField)new DropdownField(KinesisTransport.CK_AWS_REGION, "AWS Region", Regions.US_EAST_1.getName(), AWS.buildRegionChoices(), "The AWS region the Kinesis stream is running in.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField((ConfigurationField)new TextField(KinesisTransport.CK_ACCESS_KEY, "AWS access key", "", "Access key of an AWS user with sufficient permissions. (See documentation)", ConfigurationField.Optional.OPTIONAL));
            r.addField((ConfigurationField)new TextField(KinesisTransport.CK_SECRET_KEY, "AWS secret key", "", "Secret key of an AWS user with sufficient permissions. (See documentation)", ConfigurationField.Optional.OPTIONAL, new TextField.Attribute[]{TextField.Attribute.IS_PASSWORD}));
            r.addField((ConfigurationField)new TextField(KinesisTransport.CK_ASSUME_ROLE_ARN, "AWS assume role ARN", "", "Role ARN with required permissions (cross account access)", ConfigurationField.Optional.OPTIONAL));
            r.addField((ConfigurationField)new TextField(KinesisTransport.CK_KINESIS_STREAM_NAME, "Kinesis Stream name", "", "The name of the Kinesis stream that receives your messages. See README for instructions on how to connect messages to a Kinesis Stream.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField((ConfigurationField)new NumberField(KinesisTransport.CK_KINESIS_RECORD_BATCH_SIZE, "Kinesis Record batch size.", 10000, "The number of Kinesis records to fetch at a time. Each record may be up to 1MB in size. The AWS default is 10,000. Enter a smaller value to process smaller chunks at a time.", ConfigurationField.Optional.OPTIONAL, new NumberField.Attribute[]{NumberField.Attribute.ONLY_POSITIVE}));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<KinesisTransport> {
        public KinesisTransport create(org.graylog2.plugin.configuration.Configuration var1);

        public Config getConfig();
    }
}

