/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IShutdownNotificationAware;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import com.amazonaws.services.kinesis.multilang.DrainChildSTDERRTask;
import com.amazonaws.services.kinesis.multilang.MessageReader;
import com.amazonaws.services.kinesis.multilang.MessageWriter;
import com.amazonaws.services.kinesis.multilang.MultiLangProtocol;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangRecordProcessor
implements IRecordProcessor,
IShutdownNotificationAware {
    private static final Log LOG = LogFactory.getLog(MultiLangRecordProcessor.class);
    private static final int EXIT_VALUE = 1;
    private volatile boolean initialized;
    private String shardId;
    private Future<?> stderrReadTask;
    private MessageWriter messageWriter;
    private MessageReader messageReader;
    private DrainChildSTDERRTask readSTDERRTask;
    private ProcessBuilder processBuilder;
    private Process process;
    private ExecutorService executorService;
    private ProcessState state;
    private ObjectMapper objectMapper;
    private MultiLangProtocol protocol;
    private KinesisClientLibConfiguration configuration;

    @Override
    public void initialize(InitializationInput initializationInput) {
        try {
            this.shardId = initializationInput.getShardId();
            try {
                this.process = this.startProcess();
            }
            catch (IOException e) {
                throw new IOException("Failed to start client executable", e);
            }
            this.messageWriter.initialize(this.process.getOutputStream(), this.shardId, this.objectMapper, this.executorService);
            this.messageReader.initialize(this.process.getInputStream(), this.shardId, this.objectMapper, this.executorService);
            this.readSTDERRTask.initialize(this.process.getErrorStream(), this.shardId, "Reading STDERR for " + this.shardId);
            this.stderrReadTask = this.executorService.submit(this.readSTDERRTask);
            this.protocol = new MultiLangProtocol(this.messageReader, this.messageWriter, initializationInput, this.configuration);
            if (!this.protocol.initialize()) {
                throw new RuntimeException("Failed to initialize child process");
            }
            this.initialized = true;
        }
        catch (Throwable t) {
            this.stopProcessing("Encountered an error while trying to initialize record processor", t);
        }
    }

    @Override
    public void processRecords(ProcessRecordsInput processRecordsInput) {
        try {
            if (!this.protocol.processRecords(processRecordsInput)) {
                throw new RuntimeException("Child process failed to process records");
            }
        }
        catch (Throwable t) {
            this.stopProcessing("Encountered an error while trying to process records", t);
        }
    }

    @Override
    public void shutdown(ShutdownInput shutdownInput) {
        if (!this.initialized) {
            LOG.info("Record processor was not initialized and will not have a child process, so not invoking child process shutdown.");
            this.state = ProcessState.SHUTDOWN;
            return;
        }
        try {
            if (ProcessState.ACTIVE.equals((Object)this.state)) {
                if (!this.protocol.shutdown(shutdownInput.getCheckpointer(), shutdownInput.getShutdownReason())) {
                    throw new RuntimeException("Child process failed to shutdown");
                }
                this.childProcessShutdownSequence();
            } else {
                LOG.warn("Shutdown was called but this processor is already shutdown. Not doing anything.");
            }
        }
        catch (Throwable t) {
            if (ProcessState.ACTIVE.equals((Object)this.state)) {
                this.stopProcessing("Encountered an error while trying to shutdown child process", t);
            }
            this.stopProcessing("Encountered an error during shutdown, but it appears the processor has already been shutdown", t);
        }
    }

    @Override
    public void shutdownRequested(IRecordProcessorCheckpointer checkpointer) {
        LOG.info("Shutdown is requested.");
        if (!this.initialized) {
            LOG.info("Record processor was not initialized so no need to initiate a final checkpoint.");
            return;
        }
        LOG.info("Requesting a checkpoint on shutdown notification.");
        if (!this.protocol.shutdownRequested(checkpointer)) {
            LOG.error("Child process failed to complete shutdown notification.");
        }
    }

    MultiLangRecordProcessor(ProcessBuilder processBuilder, ExecutorService executorService, ObjectMapper objectMapper, KinesisClientLibConfiguration configuration) {
        this(processBuilder, executorService, objectMapper, new MessageWriter(), new MessageReader(), new DrainChildSTDERRTask(), configuration);
    }

    MultiLangRecordProcessor(ProcessBuilder processBuilder, ExecutorService executorService, ObjectMapper objectMapper, MessageWriter messageWriter, MessageReader messageReader, DrainChildSTDERRTask readSTDERRTask, KinesisClientLibConfiguration configuration) {
        this.executorService = executorService;
        this.processBuilder = processBuilder;
        this.objectMapper = objectMapper;
        this.messageWriter = messageWriter;
        this.messageReader = messageReader;
        this.readSTDERRTask = readSTDERRTask;
        this.configuration = configuration;
        this.state = ProcessState.ACTIVE;
    }

    private void childProcessShutdownSequence() {
        try {
            if (this.messageWriter.isOpen()) {
                this.messageWriter.close();
            }
        }
        catch (IOException e) {
            LOG.error("Encountered exception while trying to close output stream.", e);
        }
        this.safelyWaitOnFuture(this.messageReader.drainSTDOUT(), "draining STDOUT");
        this.safelyWaitOnFuture(this.stderrReadTask, "draining STDERR");
        this.safelyCloseInputStream(this.process.getErrorStream(), "STDERR");
        this.safelyCloseInputStream(this.process.getInputStream(), "STDOUT");
        try {
            LOG.info("Child process exited with value: " + this.process.waitFor());
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted before process finished exiting. Attempting to kill process.");
            this.process.destroy();
        }
        this.state = ProcessState.SHUTDOWN;
    }

    private void safelyCloseInputStream(InputStream inputStream, String name) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOG.error("Encountered exception while trying to close " + name + " stream.", e);
        }
    }

    private void safelyWaitOnFuture(Future<?> future, String whatThisFutureIsDoing) {
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Encountered error while " + whatThisFutureIsDoing + " for shard " + this.shardId, e);
        }
    }

    private void stopProcessing(String message, Throwable reason) {
        try {
            LOG.error(message, reason);
            if (!this.state.equals((Object)ProcessState.SHUTDOWN)) {
                this.childProcessShutdownSequence();
            }
        }
        catch (Throwable t) {
            LOG.error("Encountered error while trying to shutdown", t);
        }
        this.exit();
    }

    void exit() {
        System.exit(1);
    }

    Process startProcess() throws IOException {
        return this.processBuilder.start();
    }

    private static enum ProcessState {
        ACTIVE,
        SHUTDOWN;

    }
}

