/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.multilang.LineReaderTask;
import java.io.BufferedReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DrainChildSTDOUTTask
extends LineReaderTask<Boolean> {
    private static final Log LOG = LogFactory.getLog(DrainChildSTDOUTTask.class);

    DrainChildSTDOUTTask() {
    }

    @Override
    protected LineReaderTask.HandleLineResult<Boolean> handleLine(String line) {
        LOG.info("Drained line for shard " + this.getShardId() + ": " + line);
        return new LineReaderTask.HandleLineResult<Boolean>();
    }

    @Override
    protected Boolean returnAfterException(Exception e) {
        LOG.info("Encountered exception while draining STDOUT of child process for shard " + this.getShardId(), e);
        return false;
    }

    @Override
    protected Boolean returnAfterEndOfInput() {
        return true;
    }

    public LineReaderTask<Boolean> initialize(BufferedReader reader, String shardId) {
        return this.initialize(reader, shardId, "Draining STDOUT for " + shardId);
    }
}

