/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesis.model.ListShardsRequest;
import java.util.Date;

@SdkInternalApi
public class ListShardsRequestMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final MarshallingInfo<String> EXCLUSIVESTARTSHARDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartShardId").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").build();
    private static final MarshallingInfo<Date> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").timestampFormat("unixTimestampInMillis").build();
    private static final ListShardsRequestMarshaller instance = new ListShardsRequestMarshaller();

    public static ListShardsRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ListShardsRequest listShardsRequest, ProtocolMarshaller protocolMarshaller) {
        if (listShardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(listShardsRequest.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(listShardsRequest.getNextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listShardsRequest.getExclusiveStartShardId(), EXCLUSIVESTARTSHARDID_BINDING);
            protocolMarshaller.marshall(listShardsRequest.getMaxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall(listShardsRequest.getStreamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

