/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceRouteRequestMarshaller
implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {
    @Override
    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {
        if (replaceRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReplaceRouteRequest> request = new DefaultRequest<ReplaceRouteRequest>(replaceRouteRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(replaceRouteRequest.getDestinationCidrBlock()));
        }
        if (replaceRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString(replaceRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (replaceRouteRequest.getDestinationPrefixListId() != null) {
            request.addParameter("DestinationPrefixListId", StringUtils.fromString(replaceRouteRequest.getDestinationPrefixListId()));
        }
        if (replaceRouteRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(replaceRouteRequest.getVpcEndpointId()));
        }
        if (replaceRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString(replaceRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (replaceRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(replaceRouteRequest.getGatewayId()));
        }
        if (replaceRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(replaceRouteRequest.getInstanceId()));
        }
        if (replaceRouteRequest.getLocalTarget() != null) {
            request.addParameter("LocalTarget", StringUtils.fromBoolean(replaceRouteRequest.getLocalTarget()));
        }
        if (replaceRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString(replaceRouteRequest.getNatGatewayId()));
        }
        if (replaceRouteRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString(replaceRouteRequest.getTransitGatewayId()));
        }
        if (replaceRouteRequest.getLocalGatewayId() != null) {
            request.addParameter("LocalGatewayId", StringUtils.fromString(replaceRouteRequest.getLocalGatewayId()));
        }
        if (replaceRouteRequest.getCarrierGatewayId() != null) {
            request.addParameter("CarrierGatewayId", StringUtils.fromString(replaceRouteRequest.getCarrierGatewayId()));
        }
        if (replaceRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(replaceRouteRequest.getNetworkInterfaceId()));
        }
        if (replaceRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(replaceRouteRequest.getRouteTableId()));
        }
        if (replaceRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString(replaceRouteRequest.getVpcPeeringConnectionId()));
        }
        return request;
    }
}

