/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PurchaseRequest;
import com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class PurchaseScheduledInstancesRequestMarshaller
implements Marshaller<Request<PurchaseScheduledInstancesRequest>, PurchaseScheduledInstancesRequest> {
    @Override
    public Request<PurchaseScheduledInstancesRequest> marshall(PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {
        if (purchaseScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseScheduledInstancesRequest> request = new DefaultRequest<PurchaseScheduledInstancesRequest>(purchaseScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString(purchaseScheduledInstancesRequest.getClientToken()));
        SdkInternalList purchaseScheduledInstancesRequestPurchaseRequestsList = (SdkInternalList)purchaseScheduledInstancesRequest.getPurchaseRequests();
        if (!purchaseScheduledInstancesRequestPurchaseRequestsList.isEmpty() || !purchaseScheduledInstancesRequestPurchaseRequestsList.isAutoConstruct()) {
            int purchaseRequestsListIndex = 1;
            for (PurchaseRequest purchaseScheduledInstancesRequestPurchaseRequestsListValue : purchaseScheduledInstancesRequestPurchaseRequestsList) {
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.getInstanceCount() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".InstanceCount", StringUtils.fromInteger(purchaseScheduledInstancesRequestPurchaseRequestsListValue.getInstanceCount()));
                }
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.getPurchaseToken() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".PurchaseToken", StringUtils.fromString(purchaseScheduledInstancesRequestPurchaseRequestsListValue.getPurchaseToken()));
                }
                ++purchaseRequestsListIndex;
            }
        }
        return request;
    }
}

