/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CidrAuthorizationContext;
import com.amazonaws.services.ec2.model.ProvisionByoipCidrRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ProvisionByoipCidrRequestMarshaller
implements Marshaller<Request<ProvisionByoipCidrRequest>, ProvisionByoipCidrRequest> {
    @Override
    public Request<ProvisionByoipCidrRequest> marshall(ProvisionByoipCidrRequest provisionByoipCidrRequest) {
        SdkInternalList provisionByoipCidrRequestPoolTagSpecificationsList;
        CidrAuthorizationContext cidrAuthorizationContext;
        if (provisionByoipCidrRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ProvisionByoipCidrRequest> request = new DefaultRequest<ProvisionByoipCidrRequest>(provisionByoipCidrRequest, "AmazonEC2");
        request.addParameter("Action", "ProvisionByoipCidr");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (provisionByoipCidrRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString(provisionByoipCidrRequest.getCidr()));
        }
        if ((cidrAuthorizationContext = provisionByoipCidrRequest.getCidrAuthorizationContext()) != null) {
            if (cidrAuthorizationContext.getMessage() != null) {
                request.addParameter("CidrAuthorizationContext.Message", StringUtils.fromString(cidrAuthorizationContext.getMessage()));
            }
            if (cidrAuthorizationContext.getSignature() != null) {
                request.addParameter("CidrAuthorizationContext.Signature", StringUtils.fromString(cidrAuthorizationContext.getSignature()));
            }
        }
        if (provisionByoipCidrRequest.getPubliclyAdvertisable() != null) {
            request.addParameter("PubliclyAdvertisable", StringUtils.fromBoolean(provisionByoipCidrRequest.getPubliclyAdvertisable()));
        }
        if (provisionByoipCidrRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(provisionByoipCidrRequest.getDescription()));
        }
        if (!(provisionByoipCidrRequestPoolTagSpecificationsList = (SdkInternalList)provisionByoipCidrRequest.getPoolTagSpecifications()).isEmpty() || !provisionByoipCidrRequestPoolTagSpecificationsList.isAutoConstruct()) {
            int poolTagSpecificationsListIndex = 1;
            for (TagSpecification provisionByoipCidrRequestPoolTagSpecificationsListValue : provisionByoipCidrRequestPoolTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (provisionByoipCidrRequestPoolTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("PoolTagSpecification." + poolTagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(provisionByoipCidrRequestPoolTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)provisionByoipCidrRequestPoolTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("PoolTagSpecification." + poolTagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("PoolTagSpecification." + poolTagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++poolTagSpecificationsListIndex;
            }
        }
        return request;
    }
}

