/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CapacityReservationSpecification;
import com.amazonaws.services.ec2.model.CapacityReservationTarget;
import com.amazonaws.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyInstanceCapacityReservationAttributesRequestMarshaller
implements Marshaller<Request<ModifyInstanceCapacityReservationAttributesRequest>, ModifyInstanceCapacityReservationAttributesRequest> {
    @Override
    public Request<ModifyInstanceCapacityReservationAttributesRequest> marshall(ModifyInstanceCapacityReservationAttributesRequest modifyInstanceCapacityReservationAttributesRequest) {
        CapacityReservationSpecification capacityReservationSpecification;
        if (modifyInstanceCapacityReservationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceCapacityReservationAttributesRequest> request = new DefaultRequest<ModifyInstanceCapacityReservationAttributesRequest>(modifyInstanceCapacityReservationAttributesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceCapacityReservationAttributes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceCapacityReservationAttributesRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(modifyInstanceCapacityReservationAttributesRequest.getInstanceId()));
        }
        if ((capacityReservationSpecification = modifyInstanceCapacityReservationAttributesRequest.getCapacityReservationSpecification()) != null) {
            CapacityReservationTarget capacityReservationTarget;
            if (capacityReservationSpecification.getCapacityReservationPreference() != null) {
                request.addParameter("CapacityReservationSpecification.CapacityReservationPreference", StringUtils.fromString(capacityReservationSpecification.getCapacityReservationPreference()));
            }
            if ((capacityReservationTarget = capacityReservationSpecification.getCapacityReservationTarget()) != null) {
                if (capacityReservationTarget.getCapacityReservationId() != null) {
                    request.addParameter("CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationId", StringUtils.fromString(capacityReservationTarget.getCapacityReservationId()));
                }
                if (capacityReservationTarget.getCapacityReservationResourceGroupArn() != null) {
                    request.addParameter("CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationResourceGroupArn", StringUtils.fromString(capacityReservationTarget.getCapacityReservationResourceGroupArn()));
                }
            }
        }
        return request;
    }
}

