/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class KeyPairInfoStaxUnmarshaller
implements Unmarshaller<KeyPairInfo, StaxUnmarshallerContext> {
    private static KeyPairInfoStaxUnmarshaller instance;

    @Override
    public KeyPairInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyPairInfo keyPairInfo = new KeyPairInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyPairInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("keyPairId", targetDepth)) {
                    keyPairInfo.setKeyPairId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyFingerprint", targetDepth)) {
                    keyPairInfo.setKeyFingerprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyName", targetDepth)) {
                    keyPairInfo.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    keyPairInfo.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                keyPairInfo.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyPairInfo;
    }

    public static KeyPairInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairInfoStaxUnmarshaller();
        }
        return instance;
    }
}

