/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeLocalGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLocalGatewaysRequestMarshaller
implements Marshaller<Request<DescribeLocalGatewaysRequest>, DescribeLocalGatewaysRequest> {
    @Override
    public Request<DescribeLocalGatewaysRequest> marshall(DescribeLocalGatewaysRequest describeLocalGatewaysRequest) {
        SdkInternalList describeLocalGatewaysRequestFiltersList;
        if (describeLocalGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLocalGatewaysRequest> request = new DefaultRequest<DescribeLocalGatewaysRequest>(describeLocalGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLocalGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeLocalGatewaysRequestLocalGatewayIdsList = (SdkInternalList)describeLocalGatewaysRequest.getLocalGatewayIds();
        if (!describeLocalGatewaysRequestLocalGatewayIdsList.isEmpty() || !describeLocalGatewaysRequestLocalGatewayIdsList.isAutoConstruct()) {
            int localGatewayIdsListIndex = 1;
            for (String describeLocalGatewaysRequestLocalGatewayIdsListValue : describeLocalGatewaysRequestLocalGatewayIdsList) {
                if (describeLocalGatewaysRequestLocalGatewayIdsListValue != null) {
                    request.addParameter("LocalGatewayId." + localGatewayIdsListIndex, StringUtils.fromString(describeLocalGatewaysRequestLocalGatewayIdsListValue));
                }
                ++localGatewayIdsListIndex;
            }
        }
        if (!(describeLocalGatewaysRequestFiltersList = (SdkInternalList)describeLocalGatewaysRequest.getFilters()).isEmpty() || !describeLocalGatewaysRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeLocalGatewaysRequestFiltersListValue : describeLocalGatewaysRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeLocalGatewaysRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeLocalGatewaysRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeLocalGatewaysRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeLocalGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeLocalGatewaysRequest.getMaxResults()));
        }
        if (describeLocalGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeLocalGatewaysRequest.getNextToken()));
        }
        return request;
    }
}

